/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink.graphics;

public class Color {
    public final int rgba;
    public static final Color NONE = new Color(0);
    public static final Color BLACK = new Color(255);
    public static final Color WHITE = new Color(-1);

    public Color(Color other) {
        this.rgba = other.rgba;
    }

    public Color(int rgba) {
        this.rgba = rgba;
    }

    public Color(int r, int g, int b, int a) {
        this.rgba = (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public Color(int r, int g, int b, float a) {
        this(r, g, b, Math.round(a * 255.0f));
    }

    public final int r() {
        return this.rgba >> 24 & 0xFF;
    }

    public final int g() {
        return this.rgba >> 16 & 0xFF;
    }

    public final int b() {
        return this.rgba >> 8 & 0xFF;
    }

    public final int a() {
        return this.rgba & 0xFF;
    }

    public final float r_f() {
        return (float)this.r() / 255.0f;
    }

    public final float g_f() {
        return (float)this.g() / 255.0f;
    }

    public final float b_f() {
        return (float)this.b() / 255.0f;
    }

    public final float a_f() {
        return (float)this.a() / 255.0f;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Color)) {
            return false;
        }
        return this.rgba == ((Color)obj).rgba;
    }

    public final int hashCode() {
        return this.rgba;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.r() + ", " + this.g() + ", " + this.b() + ", " + this.a() + ")";
    }
}

