/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.Engine;
import com.myscript.iink.IRenderTarget;
import com.myscript.iink.IRendererListener;
import com.myscript.iink.ListenerList;
import com.myscript.iink.NativeFunctions;
import com.myscript.iink.graphics.ICanvas;
import com.myscript.iink.graphics.IStrokerFactory;
import com.myscript.iink.graphics.Point;
import com.myscript.iink.graphics.Transform;
import com.myscript.util.IAutoCloseable;

public class Renderer
implements IAutoCloseable {
    long nativeRef;
    private IRenderTarget renderTarget;
    private ListenerList<IRendererListener> listeners;

    Renderer(Engine engine, float dpiX, float dpiY, IRenderTarget renderTarget) {
        this.nativeRef = NativeFunctions.createRenderer(engine.nativeRef, dpiX, dpiY, renderTarget, this);
        this.renderTarget = renderTarget;
        this.listeners = new ListenerList();
    }

    Renderer(long nativeRef, IRenderTarget renderTarget) {
        this.nativeRef = nativeRef;
        this.renderTarget = renderTarget;
        this.listeners = new ListenerList();
    }

    @Override
    public final void close() {
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyRenderer(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    private final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final void addListener(IRendererListener listener) {
        this.checkNotClosed();
        this.listeners.add(listener);
    }

    public final void removeListener(IRendererListener listener) {
        this.checkNotClosed();
        this.listeners.remove(listener);
    }

    public float getDpiX() {
        this.checkNotClosed();
        return NativeFunctions.getDpiX(this.nativeRef);
    }

    public float getDpiY() {
        this.checkNotClosed();
        return NativeFunctions.getDpiY(this.nativeRef);
    }

    public float getPixelSize() {
        this.checkNotClosed();
        return NativeFunctions.getPixelSize(this.nativeRef);
    }

    public final float getViewScale() {
        this.checkNotClosed();
        return NativeFunctions.getViewScale(this.nativeRef);
    }

    public final void setViewScale(float scale) throws IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.setViewScale(this.nativeRef, scale);
    }

    public final void zoom(float factor) throws IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.zoom(this.nativeRef, factor);
    }

    public final void zoomAt(Point p, float factor) throws IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.zoomAt(this.nativeRef, p.x, p.y, factor);
    }

    public final Point getViewOffset() {
        this.checkNotClosed();
        return NativeFunctions.getViewOffset(this.nativeRef);
    }

    public final void setViewOffset(float x, float y) {
        this.checkNotClosed();
        NativeFunctions.setViewOffset(this.nativeRef, x, y);
    }

    public Transform getViewTransform() {
        this.checkNotClosed();
        return NativeFunctions.getViewTransform(this.nativeRef);
    }

    public IRenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public final void registerStroker(String name, IStrokerFactory factory) {
        this.checkNotClosed();
        NativeFunctions.registerStroker(this.nativeRef, name, factory);
    }

    public final void unregisterStroker(String name) {
        this.checkNotClosed();
        NativeFunctions.unregisterStroker(this.nativeRef, name);
    }

    public final long drawModelAsync(int x, int y, int width, int height, ICanvas canvas) {
        this.checkNotClosed();
        return NativeFunctions.drawModelAsync(this.nativeRef, x, y, width, height, canvas);
    }

    public final void commitModelDraw(long id) {
        this.checkNotClosed();
        NativeFunctions.commitModelDraw(this.nativeRef, id);
    }

    public final void drawBackground(int x, int y, int width, int height, ICanvas canvas) {
        this.checkNotClosed();
        NativeFunctions.drawBackground(this.nativeRef, x, y, width, height, canvas);
    }

    public final void drawModel(int x, int y, int width, int height, ICanvas canvas) {
        this.commitModelDraw(this.drawModelAsync(x, y, width, height, canvas));
    }

    public final void drawTemporaryItems(int x, int y, int width, int height, ICanvas canvas) {
        this.checkNotClosed();
        NativeFunctions.drawTemporaryItems(this.nativeRef, x, y, width, height, canvas);
    }

    public final void drawCaptureStrokes(int x, int y, int width, int height, ICanvas canvas) {
        this.checkNotClosed();
        NativeFunctions.drawCaptureStrokes(this.nativeRef, x, y, width, height, canvas);
    }

    final void viewTransformChanged() {
        this.listeners.forEach(new ListenerList.Consumer<IRendererListener>(){

            @Override
            public void accept(IRendererListener listener) {
                listener.viewTransformChanged(Renderer.this);
            }
        });
    }
}

