/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.NativeFunctions;
import com.myscript.util.IAutoCloseable;
import java.io.IOException;

public class RecognitionAssetsBuilder
implements IAutoCloseable {
    long nativeRef;

    RecognitionAssetsBuilder(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public final void close() {
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyRecognitionAssetsBuilder(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    protected final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final String[] getSupportedRecognitionAssetsTypes() {
        this.checkNotClosed();
        return NativeFunctions.getSupportedRecognitionAssetsTypes(this.nativeRef);
    }

    public void compile(String type, String data) throws IllegalArgumentException, RuntimeException {
        this.checkNotClosed();
        NativeFunctions.compile(this.nativeRef, type, data);
    }

    public final String getCompilationErrors() {
        this.checkNotClosed();
        return NativeFunctions.getCompilationErrors(this.nativeRef);
    }

    public void store(String path) throws IOException {
        this.checkNotClosed();
        NativeFunctions.store(this.nativeRef, path);
    }
}

