/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.StrictMode;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;

class NativeUtils {
    NativeUtils() {
    }

    @Nullable
    private static Application getApplication() {
        try {
            return (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Application access$000() {
        return NativeUtils.getApplication();
    }

    private static class CertificateCallbackAndroid {
        private static final String TAG = "CertificateCallback";
        private static final String Kf4ef8b = "f4ef8bac9f1875bc2e2c2762c31bb1f949c04848";
        private static final String K4d8be9 = "4d8be95b0232d243bf67e13f764634b4b75cd6cf";
        private static final String Ks4gezc = "s4gezc8h9q6rcqykg4zcs69ugebcxyut99mg47d9";
        private static final String Kebaed9 = "ebaed9907ac2053a6c934518a2213b42c9508908";
        private static final String Kf976b2 = "f976b2fb18f45aa807fc681736e44a554f4e0b98";
        private static final String K9c1a5a = "9c1a5a3db7d550a39a98b80c46e6081580b226e3";
        private final Context app = NativeUtils.access$000();

        public CertificateCallbackAndroid() {
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        }

        public byte[] getInstanceData() {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            return Base64.decode((String)sharedPreferences.getString(K9c1a5a, ""), (int)0);
        }

        public byte[] getLicenseData() {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            return Base64.decode((String)sharedPreferences.getString(Kf976b2, ""), (int)0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] requestLicenseData(String urlString) {
            if (!CertificateCallbackAndroid.checkInternetPermission(this.app)) {
                return new byte[0];
            }
            try {
                URL url = new URL(urlString);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setConnectTimeout(10000);
                urlConnection.addRequestProperty("Accept", "application/vnd.myscript.atk.certificate");
                urlConnection.connect();
                InputStream input = null;
                try {
                    int bytesRead;
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode != 200) {
                        byte[] byArray2 = new byte[]{};
                        return byArray2;
                    }
                    ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
                    input = urlConnection.getInputStream();
                    byte[] buffer = new byte[2048];
                    while ((bytesRead = input.read(buffer)) > 0) {
                        contentStream.write(buffer, 0, bytesRead);
                    }
                    byte[] byArray = contentStream.toByteArray();
                    return byArray;
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    urlConnection.disconnect();
                }
            }
            catch (IOException e) {
                return new byte[0];
            }
        }

        public String getDeviceId() {
            return Settings.Secure.getString((ContentResolver)this.app.getContentResolver(), (String)"android_id");
        }

        public String getAppName() {
            return this.app.getPackageName();
        }

        public long getDate() {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            return sharedPreferences.getLong(K4d8be9, 0L);
        }

        public long getLastSuccessfulConnectionDate() {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            return sharedPreferences.getLong(Ks4gezc, -1L);
        }

        public void init(byte[] certificate) {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            byte[] oldCertificate = Base64.decode((String)sharedPreferences.getString(Kebaed9, ""), (int)0);
            if (!Arrays.equals(oldCertificate, certificate)) {
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(Kebaed9, Base64.encodeToString((byte[])certificate, (int)0));
                editor.remove(K9c1a5a);
                editor.remove(Kf976b2);
                long date = System.currentTimeMillis();
                try {
                    long firstInstallDate = this.app.getPackageManager().getPackageInfo((String)this.getAppName(), (int)0).firstInstallTime;
                    if (firstInstallDate < date) {
                        date = firstInstallDate;
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                editor.putLong(K4d8be9, date / 1000L);
                editor.apply();
            }
        }

        public void reset(byte[] certificate) {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(K4d8be9);
            editor.remove(Ks4gezc);
            editor.remove(Kebaed9);
            editor.remove(Kf976b2);
            editor.remove(K9c1a5a);
            editor.apply();
            this.init(certificate);
        }

        public void storeLicenseData(byte[] licenceData) {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(Kf976b2, Base64.encodeToString((byte[])licenceData, (int)0));
            editor.apply();
        }

        public void storeLastSuccessfulConnectionDate() {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            long date = System.currentTimeMillis();
            editor.putLong(Ks4gezc, date / 1000L);
            editor.apply();
        }

        public void storeInstanceData(byte[] instanceData) {
            SharedPreferences sharedPreferences = this.app.getSharedPreferences(Kf4ef8b, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(K9c1a5a, Base64.encodeToString((byte[])instanceData, (int)0));
            editor.apply();
        }

        private static boolean checkInternetPermission(Context context) {
            int res = context.checkCallingOrSelfPermission("android.permission.INTERNET");
            return res == 0;
        }
    }
}

