/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

public enum MimeType {
    TEXT,
    HTML,
    MATHML,
    LATEX,
    GRAPHML,
    MUSICXML,
    SVG,
    JIIX,
    JPEG,
    PNG,
    GIF,
    PDF,
    DOCX,
    PPTX,
    OFFICE_CLIPBOARD;


    public String getName() {
        switch (this) {
            case TEXT: {
                return "Text File";
            }
            case HTML: {
                return "HTML Document";
            }
            case MATHML: {
                return "MathML";
            }
            case LATEX: {
                return "LaTeX";
            }
            case GRAPHML: {
                return "GraphML";
            }
            case MUSICXML: {
                return "MusicXML";
            }
            case SVG: {
                return "SVG Image";
            }
            case JIIX: {
                return "JSON iink Exchange Format";
            }
            case JPEG: {
                return "JPEG Image";
            }
            case PNG: {
                return "PNG Image";
            }
            case GIF: {
                return "GIF Image";
            }
            case PDF: {
                return "PDF Document";
            }
            case DOCX: {
                return "Microsoft Word Document";
            }
            case PPTX: {
                return "Microsoft Powerpoint Presentation";
            }
            case OFFICE_CLIPBOARD: {
                return "Microsoft Office Clipboard Format (Art::GVML ClipFormat)";
            }
        }
        throw new AssertionError((Object)"Missing switch case");
    }

    public String getTypeName() {
        switch (this) {
            case TEXT: {
                return "text/plain";
            }
            case HTML: {
                return "text/html";
            }
            case MATHML: {
                return "application/mathml+xml";
            }
            case LATEX: {
                return "application/x-latex";
            }
            case GRAPHML: {
                return "application/graphml+xml";
            }
            case MUSICXML: {
                return "application/vnd.recordare.musicxml+xml";
            }
            case SVG: {
                return "image/svg+xml";
            }
            case JIIX: {
                return "application/vnd.myscript.jiix";
            }
            case JPEG: {
                return "image/jpeg";
            }
            case PNG: {
                return "image/png";
            }
            case GIF: {
                return "image/gif";
            }
            case PDF: {
                return "application/pdf";
            }
            case DOCX: {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case PPTX: {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
            case OFFICE_CLIPBOARD: {
                return "Art::GVML ClipFormat";
            }
        }
        throw new AssertionError((Object)"Missing switch case");
    }

    public String getFileExtensions() {
        switch (this) {
            case TEXT: {
                return ".txt";
            }
            case HTML: {
                return ".html";
            }
            case MATHML: {
                return ".mathml";
            }
            case LATEX: {
                return ".tex";
            }
            case GRAPHML: {
                return ".graphml";
            }
            case MUSICXML: {
                return ".xml";
            }
            case SVG: {
                return ".svg";
            }
            case JIIX: {
                return ".jiix";
            }
            case JPEG: {
                return ".jpeg,.jpg,.jpe";
            }
            case PNG: {
                return ".png";
            }
            case GIF: {
                return ".gif";
            }
            case PDF: {
                return ".pdf";
            }
            case DOCX: {
                return ".docx";
            }
            case PPTX: {
                return ".pptx";
            }
            case OFFICE_CLIPBOARD: {
                return ".gvml";
            }
        }
        throw new AssertionError((Object)"Missing switch case");
    }

    public static MimeType fromTypeName(String typeName) {
        switch (typeName) {
            case "text/plain": {
                return TEXT;
            }
            case "text/html": {
                return HTML;
            }
            case "application/mathml+xml": {
                return MATHML;
            }
            case "application/x-latex": {
                return LATEX;
            }
            case "application/graphml+xml": {
                return GRAPHML;
            }
            case "application/vnd.recordare.musicxml+xml": {
                return MUSICXML;
            }
            case "image/svg+xml": {
                return SVG;
            }
            case "application/vnd.myscript.jiix": {
                return JIIX;
            }
            case "image/jpeg": {
                return JPEG;
            }
            case "image/png": {
                return PNG;
            }
            case "image/gif": {
                return GIF;
            }
            case "application/pdf": {
                return PDF;
            }
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                return DOCX;
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                return PPTX;
            }
            case "Art::GVML ClipFormat": {
                return OFFICE_CLIPBOARD;
            }
        }
        throw new AssertionError((Object)"Missing type name");
    }

    public boolean isTextual() {
        return this.ordinal() < JPEG.ordinal();
    }

    public boolean isImage() {
        return this == SVG || this == JPEG || this == PNG || this == GIF;
    }
}

