/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.Configuration;
import com.myscript.iink.ContentPackage;
import com.myscript.iink.Editor;
import com.myscript.iink.IRenderTarget;
import com.myscript.iink.NativeFunctions;
import com.myscript.iink.PackageOpenOption;
import com.myscript.iink.ParameterSet;
import com.myscript.iink.RecognitionAssetsBuilder;
import com.myscript.iink.Renderer;
import com.myscript.util.IAutoCloseable;
import java.io.File;
import java.io.IOException;

public class Engine
implements IAutoCloseable {
    long nativeRef;
    private Configuration configuration;

    private Engine(byte[] certificate) {
        this.nativeRef = NativeFunctions.createEngine(certificate);
        this.configuration = new Configuration(NativeFunctions.getConfiguration(this.nativeRef));
    }

    public static final Engine create(byte[] certificate) throws IllegalArgumentException {
        if (certificate == null) {
            throw new NullPointerException("certificate is required");
        }
        return new Engine(certificate);
    }

    @Override
    public final void close() {
        if (this.configuration != null) {
            this.configuration.close();
            this.configuration = null;
        }
        if (this.nativeRef != 0L) {
            NativeFunctions.destroyEngine(this.nativeRef);
            this.nativeRef = 0L;
        }
    }

    public final boolean isClosed() {
        return this.nativeRef == 0L;
    }

    private final void checkNotClosed() {
        if (this.nativeRef == 0L) {
            throw new IllegalStateException(this.getClass().getName() + " closed");
        }
    }

    public final Configuration getConfiguration() {
        this.checkNotClosed();
        return this.configuration;
    }

    public final ContentPackage createPackage(File file) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, file.getAbsolutePath(), PackageOpenOption.CREATE_NEW.ordinal()));
    }

    public final ContentPackage createPackage(String path) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, path, PackageOpenOption.CREATE_NEW.ordinal()));
    }

    public final ContentPackage openPackage(File file) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, file.getAbsolutePath(), PackageOpenOption.EXISTING.ordinal()));
    }

    public final ContentPackage openPackage(File file, PackageOpenOption openOption) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, file.getAbsolutePath(), openOption.ordinal()));
    }

    public final ContentPackage openPackage(String path) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, path, PackageOpenOption.EXISTING.ordinal()));
    }

    public final ContentPackage openPackage(String path, PackageOpenOption openOption) throws IOException {
        this.checkNotClosed();
        return new ContentPackage(this, NativeFunctions.openPackage(this.nativeRef, path, openOption.ordinal()));
    }

    public final void deletePackage(File file) throws IOException, IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.deletePackage(this.nativeRef, file.getAbsolutePath());
    }

    public final void deletePackage(String path) throws IOException, IllegalArgumentException {
        this.checkNotClosed();
        NativeFunctions.deletePackage(this.nativeRef, path);
    }

    public final Renderer createRenderer(float dpiX, float dpiY, IRenderTarget renderTarget) {
        this.checkNotClosed();
        return new Renderer(this, dpiX, dpiY, renderTarget);
    }

    public final Editor createEditor(Renderer renderer) {
        this.checkNotClosed();
        return new Editor(this, renderer);
    }

    public final String[] getSupportedPartTypes() {
        this.checkNotClosed();
        return NativeFunctions.getSupportedPartTypes(this.nativeRef);
    }

    public final ParameterSet createParameterSet() {
        this.checkNotClosed();
        long nativeRef_ = NativeFunctions.createParameterSet(this.nativeRef);
        return new ParameterSet(nativeRef_);
    }

    public final RecognitionAssetsBuilder createRecognitionAssetsBuilder() {
        this.checkNotClosed();
        long nativeRef_ = NativeFunctions.createRecognitionAssetsBuilder(this.nativeRef);
        return new RecognitionAssetsBuilder(nativeRef_);
    }
}

