/*
 * Decompiled with CFR 0.152.
 */
package com.myscript.iink;

import com.myscript.iink.ContentNode;
import com.myscript.iink.graphics.Rectangle;
import java.util.HashMap;
import java.util.Map;

class ContentTree {
    private ContentNode root = null;
    private Map<String, ContentNode> nodeById = new HashMap<String, ContentNode>();

    public final synchronized ContentNode getRoot() {
        return this.root;
    }

    public final synchronized void setRoot(ContentNode newRoot) {
        if (newRoot == null) {
            this.nodeById.clear();
            this.root = null;
        } else {
            final HashMap<String, ContentNode> newNodeById = new HashMap<String, ContentNode>();
            this.traverse(newRoot, new IVisitor(){

                @Override
                public void accept(ContentNode node) {
                    newNodeById.put(node.getId(), node);
                }
            });
            if (this.root == null) {
                this.nodeById = newNodeById;
                this.root = newRoot;
            } else {
                this.traverse(this.root, new IVisitor(){

                    @Override
                    public void accept(ContentNode node) {
                        if (newNodeById.get(node.getId()) == null) {
                            ContentTree.this.nodeById.remove(node.getId());
                        }
                    }
                });
                this.traverse(newRoot, new IVisitor(){

                    @Override
                    public void accept(ContentNode node) {
                        if (ContentTree.this.nodeById.get(node.getId()) == null) {
                            ContentTree.this.nodeById.put(node.getId(), ContentTree.this.createNode(null, node.getId(), null, null, 0, null));
                        }
                    }
                });
                this.traverse(newRoot, new IVisitor(){

                    @Override
                    public void accept(ContentNode newNode) {
                        ContentNode node = (ContentNode)ContentTree.this.nodeById.get(newNode.getId());
                        node.setType(newNode.getType());
                        node.setRenderingId(newNode.getRenderingId());
                        node.setBox(newNode.getBox());
                        node.setConversionState(newNode.getConversionState());
                        node.setAttributes(newNode.getAttributes());
                        node.clearChildren();
                        for (int i = 0; i < newNode.getChildCount(); ++i) {
                            node.addChild((ContentNode)ContentTree.this.nodeById.get(newNode.getChildAt(i).getId()));
                        }
                    }
                });
                this.root = this.nodeById.get(newRoot.getId());
            }
        }
    }

    public final synchronized ContentNode getNodeById(String id) {
        return this.nodeById.get(id);
    }

    public final synchronized ContentNode createNode(String type, String id, String renderingId, Rectangle box, int conversionState, String attributes) {
        return new ContentNode(this, type, id, renderingId, box, conversionState, attributes);
    }

    private final void attachNode(ContentNode node) {
        this.nodeById.put(node.getId(), node);
    }

    private final void detachNode(ContentNode node) {
        this.nodeById.remove(node.getId());
    }

    private final void traverse(ContentNode node, IVisitor visitor) {
        if (node == null) {
            return;
        }
        visitor.accept(node);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.traverse(node.getChildAt(i), visitor);
        }
    }

    static interface IVisitor {
        public void accept(ContentNode var1);
    }
}

