/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SocialExpression
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private String socialMediaId = null;
    private String socialMediaHub = null;
    private String socialUserName = null;
    private String previewText = null;
    private String recordingId = null;
    private List<Segment> segments = new ArrayList<Segment>();
    private Boolean held = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private String provider = null;
    private String scriptId = null;
    private String peerId = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;

    public SocialExpression state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SocialExpression id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SocialExpression socialMediaId(String socialMediaId) {
        this.socialMediaId = socialMediaId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the social media.")
    @JsonProperty(value="socialMediaId")
    public String getSocialMediaId() {
        return this.socialMediaId;
    }

    public void setSocialMediaId(String socialMediaId) {
        this.socialMediaId = socialMediaId;
    }

    public SocialExpression socialMediaHub(String socialMediaHub) {
        this.socialMediaHub = socialMediaHub;
        return this;
    }

    @ApiModelProperty(example="null", value="The social network of the communication")
    @JsonProperty(value="socialMediaHub")
    public String getSocialMediaHub() {
        return this.socialMediaHub;
    }

    public void setSocialMediaHub(String socialMediaHub) {
        this.socialMediaHub = socialMediaHub;
    }

    public SocialExpression socialUserName(String socialUserName) {
        this.socialUserName = socialUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The user name for the communication.")
    @JsonProperty(value="socialUserName")
    public String getSocialUserName() {
        return this.socialUserName;
    }

    public void setSocialUserName(String socialUserName) {
        this.socialUserName = socialUserName;
    }

    public SocialExpression previewText(String previewText) {
        this.previewText = previewText;
        return this;
    }

    @ApiModelProperty(example="null", value="The text preview of the communication contents")
    @JsonProperty(value="previewText")
    public String getPreviewText() {
        return this.previewText;
    }

    public void setPreviewText(String previewText) {
        this.previewText = previewText;
    }

    public SocialExpression recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the recording associated with this chat.")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public SocialExpression segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's chat, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public SocialExpression held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public SocialExpression disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public SocialExpression startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the chat was placed on hold in the cloud clock if the chat is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public SocialExpression startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public SocialExpression connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public SocialExpression disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public SocialExpression provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the social expression.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public SocialExpression scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public SocialExpression peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public SocialExpression wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public SocialExpression afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialExpression socialExpression = (SocialExpression)o;
        return Objects.equals((Object)this.state, (Object)socialExpression.state) && Objects.equals(this.id, socialExpression.id) && Objects.equals(this.socialMediaId, socialExpression.socialMediaId) && Objects.equals(this.socialMediaHub, socialExpression.socialMediaHub) && Objects.equals(this.socialUserName, socialExpression.socialUserName) && Objects.equals(this.previewText, socialExpression.previewText) && Objects.equals(this.recordingId, socialExpression.recordingId) && Objects.equals(this.segments, socialExpression.segments) && Objects.equals(this.held, socialExpression.held) && Objects.equals((Object)this.disconnectType, (Object)socialExpression.disconnectType) && Objects.equals(this.startHoldTime, socialExpression.startHoldTime) && Objects.equals(this.startAlertingTime, socialExpression.startAlertingTime) && Objects.equals(this.connectedTime, socialExpression.connectedTime) && Objects.equals(this.disconnectedTime, socialExpression.disconnectedTime) && Objects.equals(this.provider, socialExpression.provider) && Objects.equals(this.scriptId, socialExpression.scriptId) && Objects.equals(this.peerId, socialExpression.peerId) && Objects.equals(this.wrapup, socialExpression.wrapup) && Objects.equals(this.afterCallWork, socialExpression.afterCallWork);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.socialMediaId, this.socialMediaHub, this.socialUserName, this.previewText, this.recordingId, this.segments, this.held, this.disconnectType, this.startHoldTime, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.provider, this.scriptId, this.peerId, this.wrapup, this.afterCallWork});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialExpression {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    socialMediaId: ").append(this.toIndentedString(this.socialMediaId)).append("\n");
        sb.append("    socialMediaHub: ").append(this.toIndentedString(this.socialMediaHub)).append("\n");
        sb.append("    socialUserName: ").append(this.toIndentedString(this.socialUserName)).append("\n");
        sb.append("    previewText: ").append(this.toIndentedString(this.previewText)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

