/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.Segment;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ConversationChat
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private String roomId = null;
    private String recordingId = null;
    private List<Segment> segments = new ArrayList<Segment>();
    private Boolean held = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startHoldTime = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private String provider = null;
    private String scriptId = null;
    private String peerId = null;
    private String avatarImageUrl = null;
    private JourneyContext journeyContext = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;

    public ConversationChat state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ConversationChat id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationChat roomId(String roomId) {
        this.roomId = roomId;
        return this;
    }

    @ApiModelProperty(example="null", value="The room id for the chat.")
    @JsonProperty(value="roomId")
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public ConversationChat recordingId(String recordingId) {
        this.recordingId = recordingId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the recording associated with this chat.")
    @JsonProperty(value="recordingId")
    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public ConversationChat segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's chat, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public ConversationChat held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this call is held and the person on this side hears silence.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public ConversationChat direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the chat")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public ConversationChat disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public ConversationChat startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the chat was placed on hold in the cloud clock if the chat is currently on hold. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public ConversationChat startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public ConversationChat connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public ConversationChat disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public ConversationChat provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the email.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ConversationChat scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID of the script to use.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public ConversationChat peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public ConversationChat avatarImageUrl(String avatarImageUrl) {
        this.avatarImageUrl = avatarImageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="If available, the URI to the avatar image of this communication.")
    @JsonProperty(value="avatarImageUrl")
    public String getAvatarImageUrl() {
        return this.avatarImageUrl;
    }

    public void setAvatarImageUrl(String avatarImageUrl) {
        this.avatarImageUrl = avatarImageUrl;
    }

    public ConversationChat journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="A subset of the Journey System's data relevant to a part of a conversation (for external linkage and internal usage/context).")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public ConversationChat wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public ConversationChat afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationChat conversationChat = (ConversationChat)o;
        return Objects.equals((Object)this.state, (Object)conversationChat.state) && Objects.equals(this.id, conversationChat.id) && Objects.equals(this.roomId, conversationChat.roomId) && Objects.equals(this.recordingId, conversationChat.recordingId) && Objects.equals(this.segments, conversationChat.segments) && Objects.equals(this.held, conversationChat.held) && Objects.equals((Object)this.direction, (Object)conversationChat.direction) && Objects.equals((Object)this.disconnectType, (Object)conversationChat.disconnectType) && Objects.equals(this.startHoldTime, conversationChat.startHoldTime) && Objects.equals(this.startAlertingTime, conversationChat.startAlertingTime) && Objects.equals(this.connectedTime, conversationChat.connectedTime) && Objects.equals(this.disconnectedTime, conversationChat.disconnectedTime) && Objects.equals(this.provider, conversationChat.provider) && Objects.equals(this.scriptId, conversationChat.scriptId) && Objects.equals(this.peerId, conversationChat.peerId) && Objects.equals(this.avatarImageUrl, conversationChat.avatarImageUrl) && Objects.equals(this.journeyContext, conversationChat.journeyContext) && Objects.equals(this.wrapup, conversationChat.wrapup) && Objects.equals(this.afterCallWork, conversationChat.afterCallWork);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.roomId, this.recordingId, this.segments, this.held, this.direction, this.disconnectType, this.startHoldTime, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.provider, this.scriptId, this.peerId, this.avatarImageUrl, this.journeyContext, this.wrapup, this.afterCallWork});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationChat {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    roomId: ").append(this.toIndentedString(this.roomId)).append("\n");
        sb.append("    recordingId: ").append(this.toIndentedString(this.recordingId)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    avatarImageUrl: ").append(this.toIndentedString(this.avatarImageUrl)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        UNCALLABLE("uncallable"),
        TIMEOUT("timeout");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

