/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RoutingSettings;
import java.util.HashMap;
import java.util.Map;

public class PutRoutingSettingsRequest {
    private RoutingSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public RoutingSettings getBody() {
        return this.body;
    }

    public void setBody(RoutingSettings body) {
        this.body = body;
    }

    public PutRoutingSettingsRequest withBody(RoutingSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoutingSettings> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSettingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/settings").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingSettings body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PutRoutingSettingsRequest request = new PutRoutingSettingsRequest();

        private Builder() {
        }

        public Builder withBody(RoutingSettings body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(RoutingSettings body) {
            this.request.setBody(body);
            return this;
        }

        public PutRoutingSettingsRequest build() {
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSettingsRequest.");
            }
            return this.request;
        }
    }
}

