/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Integration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchIntegrationRequest {
    private String integrationId;
    private Integration body;
    private Integer pageSize;
    private Integer pageNumber;
    private String sortBy;
    private List<Object> expand;
    private String nextPage;
    private String previousPage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public PatchIntegrationRequest withIntegrationId(String integrationId) {
        this.setIntegrationId(integrationId);
        return this;
    }

    public Integration getBody() {
        return this.body;
    }

    public void setBody(Integration body) {
        this.body = body;
    }

    public PatchIntegrationRequest withBody(Integration body) {
        this.setBody(body);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public PatchIntegrationRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public PatchIntegrationRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public PatchIntegrationRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public List<Object> getExpand() {
        return this.expand;
    }

    public void setExpand(List<Object> expand) {
        this.expand = expand;
    }

    public PatchIntegrationRequest withExpand(List<Object> expand) {
        this.setExpand(expand);
        return this;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(String nextPage) {
        this.nextPage = nextPage;
    }

    public PatchIntegrationRequest withNextPage(String nextPage) {
        this.setNextPage(nextPage);
        return this;
    }

    public String getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage(String previousPage) {
        this.previousPage = previousPage;
    }

    public PatchIntegrationRequest withPreviousPage(String previousPage) {
        this.setPreviousPage(previousPage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchIntegrationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Integration> withHttpInfo() {
        if (this.integrationId == null) {
            throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for PatchIntegrationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/integrations/{integrationId}").withPathParameter("integrationId", this.integrationId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("sortBy", "", this.sortBy).withQueryParameters("expand", "multi", this.expand).withQueryParameters("nextPage", "", this.nextPage).withQueryParameters("previousPage", "", this.previousPage).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String integrationId) {
        return new Builder().withRequiredParams(integrationId);
    }

    public static class Builder {
        private final PatchIntegrationRequest request = new PatchIntegrationRequest();

        private Builder() {
        }

        public Builder withIntegrationId(String integrationId) {
            this.request.setIntegrationId(integrationId);
            return this;
        }

        public Builder withBody(Integration body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withSortBy(String sortBy) {
            this.request.setSortBy(sortBy);
            return this;
        }

        public Builder withExpand(List<Object> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withNextPage(String nextPage) {
            this.request.setNextPage(nextPage);
            return this;
        }

        public Builder withPreviousPage(String previousPage) {
            this.request.setPreviousPage(previousPage);
            return this;
        }

        public Builder withRequiredParams(String integrationId) {
            this.request.setIntegrationId(integrationId);
            return this;
        }

        public PatchIntegrationRequest build() {
            if (this.request.integrationId == null) {
                throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for PatchIntegrationRequest.");
            }
            return this.request;
        }
    }
}

