/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.BuCopyScheduleRequest;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest {
    private String businessUnitId;
    private LocalDate weekId;
    private String scheduleId;
    private BuCopyScheduleRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getBusinessUnitId() {
        return this.businessUnitId;
    }

    public void setBusinessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest withBusinessUnitId(String businessUnitId) {
        this.setBusinessUnitId(businessUnitId);
        return this;
    }

    public LocalDate getWeekId() {
        return this.weekId;
    }

    public void setWeekId(LocalDate weekId) {
        this.weekId = weekId;
    }

    public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest withWeekId(LocalDate weekId) {
        this.setWeekId(weekId);
        return this;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest withScheduleId(String scheduleId) {
        this.setScheduleId(scheduleId);
        return this;
    }

    public BuCopyScheduleRequest getBody() {
        return this.body;
    }

    public void setBody(BuCopyScheduleRequest body) {
        this.body = body;
    }

    public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest withBody(BuCopyScheduleRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<BuCopyScheduleRequest> withHttpInfo() {
        if (this.businessUnitId == null) {
            throw new IllegalStateException("Missing the required parameter 'businessUnitId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
        }
        if (this.weekId == null) {
            throw new IllegalStateException("Missing the required parameter 'weekId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
        }
        if (this.scheduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'scheduleId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/{scheduleId}/copy").withPathParameter("businessUnitId", this.businessUnitId).withPathParameter("weekId", this.weekId).withPathParameter("scheduleId", this.scheduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String businessUnitId, LocalDate weekId, String scheduleId, BuCopyScheduleRequest body) {
        return new Builder().withRequiredParams(businessUnitId, weekId, scheduleId, body);
    }

    public static class Builder {
        private final PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest request = new PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest();

        private Builder() {
        }

        public Builder withBusinessUnitId(String businessUnitId) {
            this.request.setBusinessUnitId(businessUnitId);
            return this;
        }

        public Builder withWeekId(LocalDate weekId) {
            this.request.setWeekId(weekId);
            return this;
        }

        public Builder withScheduleId(String scheduleId) {
            this.request.setScheduleId(scheduleId);
            return this;
        }

        public Builder withBody(BuCopyScheduleRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String businessUnitId, LocalDate weekId, String scheduleId, BuCopyScheduleRequest body) {
            this.request.setBusinessUnitId(businessUnitId);
            this.request.setWeekId(weekId);
            this.request.setScheduleId(scheduleId);
            this.request.setBody(body);
            return this;
        }

        public PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest build() {
            if (this.request.businessUnitId == null) {
                throw new IllegalStateException("Missing the required parameter 'businessUnitId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
            }
            if (this.request.weekId == null) {
                throw new IllegalStateException("Missing the required parameter 'weekId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
            }
            if (this.request.scheduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'scheduleId' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWorkforcemanagementBusinessunitWeekScheduleCopyRequest.");
            }
            return this.request;
        }
    }
}

