/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetFieldconfigRequest;
import com.mypurecloud.sdk.v2.api.request.GetOrganizationsEmbeddedintegrationRequest;
import com.mypurecloud.sdk.v2.api.request.GetOrganizationsMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetOrganizationsWhitelistRequest;
import com.mypurecloud.sdk.v2.api.request.PatchOrganizationsFeatureRequest;
import com.mypurecloud.sdk.v2.api.request.PutOrganizationsEmbeddedintegrationRequest;
import com.mypurecloud.sdk.v2.api.request.PutOrganizationsMeRequest;
import com.mypurecloud.sdk.v2.api.request.PutOrganizationsWhitelistRequest;
import com.mypurecloud.sdk.v2.model.EmbeddedIntegration;
import com.mypurecloud.sdk.v2.model.FeatureState;
import com.mypurecloud.sdk.v2.model.FieldConfig;
import com.mypurecloud.sdk.v2.model.OrgWhitelistSettings;
import com.mypurecloud.sdk.v2.model.Organization;
import com.mypurecloud.sdk.v2.model.OrganizationFeatures;
import java.io.IOException;

public class OrganizationApi {
    private final ApiClient pcapiClient;

    public OrganizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public FieldConfig getFieldconfig(String type) throws IOException, ApiException {
        return this.getFieldconfig(this.createGetFieldconfigRequest(type));
    }

    public ApiResponse<FieldConfig> getFieldconfigWithHttpInfo(String type) throws IOException {
        return this.getFieldconfig(this.createGetFieldconfigRequest(type).withHttpInfo());
    }

    private GetFieldconfigRequest createGetFieldconfigRequest(String type) {
        return GetFieldconfigRequest.builder().withType(type).build();
    }

    public FieldConfig getFieldconfig(GetFieldconfigRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FieldConfig> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FieldConfig>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FieldConfig> getFieldconfig(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FieldConfig>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EmbeddedIntegration getOrganizationsEmbeddedintegration() throws IOException, ApiException {
        return this.getOrganizationsEmbeddedintegration(this.createGetOrganizationsEmbeddedintegrationRequest());
    }

    public ApiResponse<EmbeddedIntegration> getOrganizationsEmbeddedintegrationWithHttpInfo() throws IOException {
        return this.getOrganizationsEmbeddedintegration(this.createGetOrganizationsEmbeddedintegrationRequest().withHttpInfo());
    }

    private GetOrganizationsEmbeddedintegrationRequest createGetOrganizationsEmbeddedintegrationRequest() {
        return GetOrganizationsEmbeddedintegrationRequest.builder().build();
    }

    public EmbeddedIntegration getOrganizationsEmbeddedintegration(GetOrganizationsEmbeddedintegrationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EmbeddedIntegration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EmbeddedIntegration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EmbeddedIntegration> getOrganizationsEmbeddedintegration(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EmbeddedIntegration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Organization getOrganizationsMe() throws IOException, ApiException {
        return this.getOrganizationsMe(this.createGetOrganizationsMeRequest());
    }

    public ApiResponse<Organization> getOrganizationsMeWithHttpInfo() throws IOException {
        return this.getOrganizationsMe(this.createGetOrganizationsMeRequest().withHttpInfo());
    }

    private GetOrganizationsMeRequest createGetOrganizationsMeRequest() {
        return GetOrganizationsMeRequest.builder().build();
    }

    public Organization getOrganizationsMe(GetOrganizationsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Organization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Organization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Organization> getOrganizationsMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Organization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrgWhitelistSettings getOrganizationsWhitelist() throws IOException, ApiException {
        return this.getOrganizationsWhitelist(this.createGetOrganizationsWhitelistRequest());
    }

    public ApiResponse<OrgWhitelistSettings> getOrganizationsWhitelistWithHttpInfo() throws IOException {
        return this.getOrganizationsWhitelist(this.createGetOrganizationsWhitelistRequest().withHttpInfo());
    }

    private GetOrganizationsWhitelistRequest createGetOrganizationsWhitelistRequest() {
        return GetOrganizationsWhitelistRequest.builder().build();
    }

    public OrgWhitelistSettings getOrganizationsWhitelist(GetOrganizationsWhitelistRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrgWhitelistSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrgWhitelistSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrgWhitelistSettings> getOrganizationsWhitelist(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrgWhitelistSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrganizationFeatures patchOrganizationsFeature(String featureName, FeatureState enabled) throws IOException, ApiException {
        return this.patchOrganizationsFeature(this.createPatchOrganizationsFeatureRequest(featureName, enabled));
    }

    public ApiResponse<OrganizationFeatures> patchOrganizationsFeatureWithHttpInfo(String featureName, FeatureState enabled) throws IOException {
        return this.patchOrganizationsFeature(this.createPatchOrganizationsFeatureRequest(featureName, enabled).withHttpInfo());
    }

    private PatchOrganizationsFeatureRequest createPatchOrganizationsFeatureRequest(String featureName, FeatureState enabled) {
        return PatchOrganizationsFeatureRequest.builder().withFeatureName(featureName).withEnabled(enabled).build();
    }

    public OrganizationFeatures patchOrganizationsFeature(PatchOrganizationsFeatureRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrganizationFeatures> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrganizationFeatures>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrganizationFeatures> patchOrganizationsFeature(ApiRequest<FeatureState> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrganizationFeatures>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EmbeddedIntegration putOrganizationsEmbeddedintegration(EmbeddedIntegration body) throws IOException, ApiException {
        return this.putOrganizationsEmbeddedintegration(this.createPutOrganizationsEmbeddedintegrationRequest(body));
    }

    public ApiResponse<EmbeddedIntegration> putOrganizationsEmbeddedintegrationWithHttpInfo(EmbeddedIntegration body) throws IOException {
        return this.putOrganizationsEmbeddedintegration(this.createPutOrganizationsEmbeddedintegrationRequest(body).withHttpInfo());
    }

    private PutOrganizationsEmbeddedintegrationRequest createPutOrganizationsEmbeddedintegrationRequest(EmbeddedIntegration body) {
        return PutOrganizationsEmbeddedintegrationRequest.builder().withBody(body).build();
    }

    public EmbeddedIntegration putOrganizationsEmbeddedintegration(PutOrganizationsEmbeddedintegrationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EmbeddedIntegration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EmbeddedIntegration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EmbeddedIntegration> putOrganizationsEmbeddedintegration(ApiRequest<EmbeddedIntegration> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EmbeddedIntegration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Organization putOrganizationsMe(Organization body) throws IOException, ApiException {
        return this.putOrganizationsMe(this.createPutOrganizationsMeRequest(body));
    }

    public ApiResponse<Organization> putOrganizationsMeWithHttpInfo(Organization body) throws IOException {
        return this.putOrganizationsMe(this.createPutOrganizationsMeRequest(body).withHttpInfo());
    }

    private PutOrganizationsMeRequest createPutOrganizationsMeRequest(Organization body) {
        return PutOrganizationsMeRequest.builder().withBody(body).build();
    }

    public Organization putOrganizationsMe(PutOrganizationsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Organization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Organization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Organization> putOrganizationsMe(ApiRequest<Organization> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Organization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrgWhitelistSettings putOrganizationsWhitelist(OrgWhitelistSettings body) throws IOException, ApiException {
        return this.putOrganizationsWhitelist(this.createPutOrganizationsWhitelistRequest(body));
    }

    public ApiResponse<OrgWhitelistSettings> putOrganizationsWhitelistWithHttpInfo(OrgWhitelistSettings body) throws IOException {
        return this.putOrganizationsWhitelist(this.createPutOrganizationsWhitelistRequest(body).withHttpInfo());
    }

    private PutOrganizationsWhitelistRequest createPutOrganizationsWhitelistRequest(OrgWhitelistSettings body) {
        return PutOrganizationsWhitelistRequest.builder().withBody(body).build();
    }

    public OrgWhitelistSettings putOrganizationsWhitelist(PutOrganizationsWhitelistRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrgWhitelistSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrgWhitelistSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrgWhitelistSettings> putOrganizationsWhitelist(ApiRequest<OrgWhitelistSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrgWhitelistSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

