/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LocationDefinition;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Location
implements Serializable {
    private String id = null;
    private String floorplanId = null;
    private Map<String, Double> coordinates = null;
    private String notes = null;
    private LocationDefinition locationDefinition = null;

    public Location id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the location")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the location floorplan image")
    @JsonProperty(value="floorplanId")
    public String getFloorplanId() {
        return this.floorplanId;
    }

    public Location coordinates(Map<String, Double> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(example="null", value="Users coordinates on the floorplan. Only used when floorplanImage is set")
    @JsonProperty(value="coordinates")
    public Map<String, Double> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Map<String, Double> coordinates) {
        this.coordinates = coordinates;
    }

    public Location notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional description on the users location")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Location locationDefinition(LocationDefinition locationDefinition) {
        this.locationDefinition = locationDefinition;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="locationDefinition")
    public LocationDefinition getLocationDefinition() {
        return this.locationDefinition;
    }

    public void setLocationDefinition(LocationDefinition locationDefinition) {
        this.locationDefinition = locationDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return Objects.equals(this.id, location.id) && Objects.equals(this.floorplanId, location.floorplanId) && Objects.equals(this.coordinates, location.coordinates) && Objects.equals(this.notes, location.notes) && Objects.equals(this.locationDefinition, location.locationDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.floorplanId, this.coordinates, this.notes, this.locationDefinition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Location {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    floorplanId: ").append(this.toIndentedString(this.floorplanId)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    locationDefinition: ").append(this.toIndentedString(this.locationDefinition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

