/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Geolocation;
import java.util.HashMap;
import java.util.Map;

public class PatchUserGeolocationRequest {
    private String userId;
    private String clientId;
    private Geolocation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserGeolocationRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PatchUserGeolocationRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public Geolocation getBody() {
        return this.body;
    }

    public void setBody(Geolocation body) {
        this.body = body;
    }

    public PatchUserGeolocationRequest withBody(Geolocation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserGeolocationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Geolocation> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserGeolocationRequest.");
        }
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PatchUserGeolocationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserGeolocationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}/geolocations/{clientId}").withPathParameter("userId", this.userId).withPathParameter("clientId", this.clientId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String clientId, Geolocation body) {
        return new Builder().withRequiredParams(userId, clientId, body);
    }

    public static class Builder {
        private final PatchUserGeolocationRequest request = new PatchUserGeolocationRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withBody(Geolocation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String clientId, Geolocation body) {
            this.request.setUserId(userId);
            this.request.setClientId(clientId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserGeolocationRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchUserGeolocationRequest.");
            }
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PatchUserGeolocationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUserGeolocationRequest.");
            }
            return this.request;
        }
    }
}

