/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KeywordSet;
import java.util.HashMap;
import java.util.Map;

public class PutQualityKeywordsetRequest {
    private String keywordSetId;
    private KeywordSet body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKeywordSetId() {
        return this.keywordSetId;
    }

    public void setKeywordSetId(String keywordSetId) {
        this.keywordSetId = keywordSetId;
    }

    public PutQualityKeywordsetRequest withKeywordSetId(String keywordSetId) {
        this.setKeywordSetId(keywordSetId);
        return this;
    }

    public KeywordSet getBody() {
        return this.body;
    }

    public void setBody(KeywordSet body) {
        this.body = body;
    }

    public PutQualityKeywordsetRequest withBody(KeywordSet body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityKeywordsetRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KeywordSet> withHttpInfo() {
        if (this.keywordSetId == null) {
            throw new IllegalStateException("Missing the required parameter 'keywordSetId' when building request for PutQualityKeywordsetRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityKeywordsetRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/keywordsets/{keywordSetId}").withPathParameter("keywordSetId", this.keywordSetId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String keywordSetId, KeywordSet body) {
        return new Builder().withRequiredParams(keywordSetId, body);
    }

    public static class Builder {
        private final PutQualityKeywordsetRequest request = new PutQualityKeywordsetRequest();

        private Builder() {
        }

        public Builder withKeywordSetId(String keywordSetId) {
            this.request.setKeywordSetId(keywordSetId);
            return this;
        }

        public Builder withBody(KeywordSet body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String keywordSetId, KeywordSet body) {
            this.request.setKeywordSetId(keywordSetId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityKeywordsetRequest build() {
            if (this.request.keywordSetId == null) {
                throw new IllegalStateException("Missing the required parameter 'keywordSetId' when building request for PutQualityKeywordsetRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityKeywordsetRequest.");
            }
            return this.request;
        }
    }
}

