/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DncList;
import java.util.HashMap;
import java.util.Map;

public class PutOutboundDnclistRequest {
    private String dncListId;
    private DncList body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDncListId() {
        return this.dncListId;
    }

    public void setDncListId(String dncListId) {
        this.dncListId = dncListId;
    }

    public PutOutboundDnclistRequest withDncListId(String dncListId) {
        this.setDncListId(dncListId);
        return this;
    }

    public DncList getBody() {
        return this.body;
    }

    public void setBody(DncList body) {
        this.body = body;
    }

    public PutOutboundDnclistRequest withBody(DncList body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundDnclistRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DncList> withHttpInfo() {
        if (this.dncListId == null) {
            throw new IllegalStateException("Missing the required parameter 'dncListId' when building request for PutOutboundDnclistRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundDnclistRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/dnclists/{dncListId}").withPathParameter("dncListId", this.dncListId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String dncListId, DncList body) {
        return new Builder().withRequiredParams(dncListId, body);
    }

    public static class Builder {
        private final PutOutboundDnclistRequest request = new PutOutboundDnclistRequest();

        private Builder() {
        }

        public Builder withDncListId(String dncListId) {
            this.request.setDncListId(dncListId);
            return this;
        }

        public Builder withBody(DncList body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String dncListId, DncList body) {
            this.request.setDncListId(dncListId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundDnclistRequest build() {
            if (this.request.dncListId == null) {
                throw new IllegalStateException("Missing the required parameter 'dncListId' when building request for PutOutboundDnclistRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOutboundDnclistRequest.");
            }
            return this.request;
        }
    }
}

