/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteRoutingQueueRequest {
    private String queueId;
    private Boolean forceDelete;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public DeleteRoutingQueueRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public Boolean getForceDelete() {
        return this.forceDelete;
    }

    public void setForceDelete(Boolean forceDelete) {
        this.forceDelete = forceDelete;
    }

    public DeleteRoutingQueueRequest withForceDelete(Boolean forceDelete) {
        this.setForceDelete(forceDelete);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteRoutingQueueRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for DeleteRoutingQueueRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/routing/queues/{queueId}").withPathParameter("queueId", this.queueId).withQueryParameters("forceDelete", "", this.forceDelete).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId) {
        return new Builder().withRequiredParams(queueId);
    }

    public static class Builder {
        private final DeleteRoutingQueueRequest request = new DeleteRoutingQueueRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withForceDelete(Boolean forceDelete) {
            this.request.setForceDelete(forceDelete);
            return this;
        }

        public Builder withRequiredParams(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public DeleteRoutingQueueRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for DeleteRoutingQueueRequest.");
            }
            return this.request;
        }
    }
}

