/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationRecordingAnnotationRequest {
    private String conversationId;
    private String recordingId;
    private String annotationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationRecordingAnnotationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public GetConversationRecordingAnnotationRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public GetConversationRecordingAnnotationRequest withAnnotationId(String annotationId) {
        this.setAnnotationId(annotationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationRecordingAnnotationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingAnnotationRequest.");
        }
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingAnnotationRequest.");
        }
        if (this.annotationId == null) {
            throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for GetConversationRecordingAnnotationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations/{annotationId}").withPathParameter("conversationId", this.conversationId).withPathParameter("recordingId", this.recordingId).withPathParameter("annotationId", this.annotationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String recordingId, String annotationId) {
        return new Builder().withRequiredParams(conversationId, recordingId, annotationId);
    }

    public static class Builder {
        private final GetConversationRecordingAnnotationRequest request = new GetConversationRecordingAnnotationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withAnnotationId(String annotationId) {
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String recordingId, String annotationId) {
            this.request.setConversationId(conversationId);
            this.request.setRecordingId(recordingId);
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public GetConversationRecordingAnnotationRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingAnnotationRequest.");
            }
            if (this.request.recordingId == null) {
                throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingAnnotationRequest.");
            }
            if (this.request.annotationId == null) {
                throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for GetConversationRecordingAnnotationRequest.");
            }
            return this.request;
        }
    }
}

