/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WebChatDeployment;
import java.util.HashMap;
import java.util.Map;

public class PutWebchatDeploymentRequest {
    private String deploymentId;
    private WebChatDeployment body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public PutWebchatDeploymentRequest withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public WebChatDeployment getBody() {
        return this.body;
    }

    public void setBody(WebChatDeployment body) {
        this.body = body;
    }

    public PutWebchatDeploymentRequest withBody(WebChatDeployment body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutWebchatDeploymentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WebChatDeployment> withHttpInfo() {
        if (this.deploymentId == null) {
            throw new IllegalStateException("Missing the required parameter 'deploymentId' when building request for PutWebchatDeploymentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWebchatDeploymentRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/webchat/deployments/{deploymentId}").withPathParameter("deploymentId", this.deploymentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String deploymentId, WebChatDeployment body) {
        return new Builder().withRequiredParams(deploymentId, body);
    }

    public static class Builder {
        private final PutWebchatDeploymentRequest request = new PutWebchatDeploymentRequest();

        private Builder() {
        }

        public Builder withDeploymentId(String deploymentId) {
            this.request.setDeploymentId(deploymentId);
            return this;
        }

        public Builder withBody(WebChatDeployment body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String deploymentId, WebChatDeployment body) {
            this.request.setDeploymentId(deploymentId);
            this.request.setBody(body);
            return this;
        }

        public PutWebchatDeploymentRequest build() {
            if (this.request.deploymentId == null) {
                throw new IllegalStateException("Missing the required parameter 'deploymentId' when building request for PutWebchatDeploymentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWebchatDeploymentRequest.");
            }
            return this.request;
        }
    }
}

