/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ConversationRoutingData;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CobrowseMediaParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date connectedTime = null;
    private Date endTime = null;
    private Date startHoldTime = null;
    private String purpose = null;
    private StateEnum state = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Boolean held = null;
    private Boolean wrapupRequired = null;
    private String wrapupPrompt = null;
    private DomainEntityRef user = null;
    private DomainEntityRef queue = null;
    private Map<String, String> attributes = null;
    private ErrorInfo errorInfo = null;
    private DomainEntityRef script = null;
    private Integer wrapupTimeoutMs = null;
    private Boolean wrapupSkipped = null;
    private Integer alertingTimeoutMs = null;
    private String provider = null;
    private DomainEntityRef externalContact = null;
    private DomainEntityRef externalOrganization = null;
    private Wrapup wrapup = null;
    private String peer = null;
    private FlaggedReasonEnum flaggedReason = null;
    private JourneyContext journeyContext = null;
    private ConversationRoutingData conversationRoutingData = null;
    private Date startAcwTime = null;
    private Date endAcwTime = null;
    private String cobrowseSessionId = null;
    private String cobrowseRole = null;
    private List<String> controlling = new ArrayList<String>();
    private String viewerUrl = null;
    private Date providerEventTime = null;

    public CobrowseMediaParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CobrowseMediaParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CobrowseMediaParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CobrowseMediaParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CobrowseMediaParticipant connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public CobrowseMediaParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public CobrowseMediaParticipant startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public CobrowseMediaParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public CobrowseMediaParticipant state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CobrowseMediaParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CobrowseMediaParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CobrowseMediaParticipant held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant is on hold.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public CobrowseMediaParticipant wrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant requires wrap-up.")
    @JsonProperty(value="wrapupRequired")
    public Boolean getWrapupRequired() {
        return this.wrapupRequired;
    }

    public void setWrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
    }

    public CobrowseMediaParticipant wrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrap-up prompt indicating the type of wrap-up to be performed.")
    @JsonProperty(value="wrapupPrompt")
    public String getWrapupPrompt() {
        return this.wrapupPrompt;
    }

    public void setWrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
    }

    public CobrowseMediaParticipant user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public CobrowseMediaParticipant queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public CobrowseMediaParticipant attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ad-hoc attributes for the participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CobrowseMediaParticipant errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the conversation ends in error, contains additional error details.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public CobrowseMediaParticipant script(DomainEntityRef script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Engage script that should be used by this participant.")
    @JsonProperty(value="script")
    public DomainEntityRef getScript() {
        return this.script;
    }

    public void setScript(DomainEntityRef script) {
        this.script = script;
    }

    public CobrowseMediaParticipant wrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time the participant has to complete wrap-up.")
    @JsonProperty(value="wrapupTimeoutMs")
    public Integer getWrapupTimeoutMs() {
        return this.wrapupTimeoutMs;
    }

    public void setWrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
    }

    public CobrowseMediaParticipant wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant has skipped wrap-up.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public CobrowseMediaParticipant alertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how long the agent has to answer an interaction before being marked as not responding.")
    @JsonProperty(value="alertingTimeoutMs")
    public Integer getAlertingTimeoutMs() {
        return this.alertingTimeoutMs;
    }

    public void setAlertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
    }

    public CobrowseMediaParticipant provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CobrowseMediaParticipant externalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the reference for the external contact.")
    @JsonProperty(value="externalContact")
    public DomainEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public CobrowseMediaParticipant externalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external org, then this will be the reference for the external org.")
    @JsonProperty(value="externalOrganization")
    public DomainEntityRef getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public CobrowseMediaParticipant wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrapup for this participant, if it has been applied.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public CobrowseMediaParticipant peer(String peer) {
        this.peer = peer;
        return this;
    }

    @ApiModelProperty(example="null", value="The peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peer")
    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }

    public CobrowseMediaParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public CobrowseMediaParticipant journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public CobrowseMediaParticipant conversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on how a communication should be routed to an agent.")
    @JsonProperty(value="conversationRoutingData")
    public ConversationRoutingData getConversationRoutingData() {
        return this.conversationRoutingData;
    }

    public void setConversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
    }

    public CobrowseMediaParticipant startAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startAcwTime")
    public Date getStartAcwTime() {
        return this.startAcwTime;
    }

    public void setStartAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
    }

    public CobrowseMediaParticipant endAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endAcwTime")
    public Date getEndAcwTime() {
        return this.endAcwTime;
    }

    public void setEndAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
    }

    public CobrowseMediaParticipant cobrowseSessionId(String cobrowseSessionId) {
        this.cobrowseSessionId = cobrowseSessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The co-browse session ID.")
    @JsonProperty(value="cobrowseSessionId")
    public String getCobrowseSessionId() {
        return this.cobrowseSessionId;
    }

    public void setCobrowseSessionId(String cobrowseSessionId) {
        this.cobrowseSessionId = cobrowseSessionId;
    }

    public CobrowseMediaParticipant cobrowseRole(String cobrowseRole) {
        this.cobrowseRole = cobrowseRole;
        return this;
    }

    @ApiModelProperty(example="null", value="This value identifies the role of the co-browse client within the co-browse session (a client is a sharer or a viewer).")
    @JsonProperty(value="cobrowseRole")
    public String getCobrowseRole() {
        return this.cobrowseRole;
    }

    public void setCobrowseRole(String cobrowseRole) {
        this.cobrowseRole = cobrowseRole;
    }

    public CobrowseMediaParticipant controlling(List<String> controlling) {
        this.controlling = controlling;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of co-browse participants for which this client has been granted control (list is empty if this client cannot control any shared pages).")
    @JsonProperty(value="controlling")
    public List<String> getControlling() {
        return this.controlling;
    }

    public void setControlling(List<String> controlling) {
        this.controlling = controlling;
    }

    public CobrowseMediaParticipant viewerUrl(String viewerUrl) {
        this.viewerUrl = viewerUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL that can be used to open co-browse session in web browser.")
    @JsonProperty(value="viewerUrl")
    public String getViewerUrl() {
        return this.viewerUrl;
    }

    public void setViewerUrl(String viewerUrl) {
        this.viewerUrl = viewerUrl;
    }

    public CobrowseMediaParticipant providerEventTime(Date providerEventTime) {
        this.providerEventTime = providerEventTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the provider event which triggered this conversation update happened in the corrected provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="providerEventTime")
    public Date getProviderEventTime() {
        return this.providerEventTime;
    }

    public void setProviderEventTime(Date providerEventTime) {
        this.providerEventTime = providerEventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CobrowseMediaParticipant cobrowseMediaParticipant = (CobrowseMediaParticipant)o;
        return Objects.equals(this.id, cobrowseMediaParticipant.id) && Objects.equals(this.name, cobrowseMediaParticipant.name) && Objects.equals(this.address, cobrowseMediaParticipant.address) && Objects.equals(this.startTime, cobrowseMediaParticipant.startTime) && Objects.equals(this.connectedTime, cobrowseMediaParticipant.connectedTime) && Objects.equals(this.endTime, cobrowseMediaParticipant.endTime) && Objects.equals(this.startHoldTime, cobrowseMediaParticipant.startHoldTime) && Objects.equals(this.purpose, cobrowseMediaParticipant.purpose) && Objects.equals((Object)this.state, (Object)cobrowseMediaParticipant.state) && Objects.equals((Object)this.direction, (Object)cobrowseMediaParticipant.direction) && Objects.equals((Object)this.disconnectType, (Object)cobrowseMediaParticipant.disconnectType) && Objects.equals(this.held, cobrowseMediaParticipant.held) && Objects.equals(this.wrapupRequired, cobrowseMediaParticipant.wrapupRequired) && Objects.equals(this.wrapupPrompt, cobrowseMediaParticipant.wrapupPrompt) && Objects.equals(this.user, cobrowseMediaParticipant.user) && Objects.equals(this.queue, cobrowseMediaParticipant.queue) && Objects.equals(this.attributes, cobrowseMediaParticipant.attributes) && Objects.equals(this.errorInfo, cobrowseMediaParticipant.errorInfo) && Objects.equals(this.script, cobrowseMediaParticipant.script) && Objects.equals(this.wrapupTimeoutMs, cobrowseMediaParticipant.wrapupTimeoutMs) && Objects.equals(this.wrapupSkipped, cobrowseMediaParticipant.wrapupSkipped) && Objects.equals(this.alertingTimeoutMs, cobrowseMediaParticipant.alertingTimeoutMs) && Objects.equals(this.provider, cobrowseMediaParticipant.provider) && Objects.equals(this.externalContact, cobrowseMediaParticipant.externalContact) && Objects.equals(this.externalOrganization, cobrowseMediaParticipant.externalOrganization) && Objects.equals(this.wrapup, cobrowseMediaParticipant.wrapup) && Objects.equals(this.peer, cobrowseMediaParticipant.peer) && Objects.equals((Object)this.flaggedReason, (Object)cobrowseMediaParticipant.flaggedReason) && Objects.equals(this.journeyContext, cobrowseMediaParticipant.journeyContext) && Objects.equals(this.conversationRoutingData, cobrowseMediaParticipant.conversationRoutingData) && Objects.equals(this.startAcwTime, cobrowseMediaParticipant.startAcwTime) && Objects.equals(this.endAcwTime, cobrowseMediaParticipant.endAcwTime) && Objects.equals(this.cobrowseSessionId, cobrowseMediaParticipant.cobrowseSessionId) && Objects.equals(this.cobrowseRole, cobrowseMediaParticipant.cobrowseRole) && Objects.equals(this.controlling, cobrowseMediaParticipant.controlling) && Objects.equals(this.viewerUrl, cobrowseMediaParticipant.viewerUrl) && Objects.equals(this.providerEventTime, cobrowseMediaParticipant.providerEventTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.connectedTime, this.endTime, this.startHoldTime, this.purpose, this.state, this.direction, this.disconnectType, this.held, this.wrapupRequired, this.wrapupPrompt, this.user, this.queue, this.attributes, this.errorInfo, this.script, this.wrapupTimeoutMs, this.wrapupSkipped, this.alertingTimeoutMs, this.provider, this.externalContact, this.externalOrganization, this.wrapup, this.peer, this.flaggedReason, this.journeyContext, this.conversationRoutingData, this.startAcwTime, this.endAcwTime, this.cobrowseSessionId, this.cobrowseRole, this.controlling, this.viewerUrl, this.providerEventTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CobrowseMediaParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupRequired: ").append(this.toIndentedString(this.wrapupRequired)).append("\n");
        sb.append("    wrapupPrompt: ").append(this.toIndentedString(this.wrapupPrompt)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    wrapupTimeoutMs: ").append(this.toIndentedString(this.wrapupTimeoutMs)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("    alertingTimeoutMs: ").append(this.toIndentedString(this.alertingTimeoutMs)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    peer: ").append(this.toIndentedString(this.peer)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    conversationRoutingData: ").append(this.toIndentedString(this.conversationRoutingData)).append("\n");
        sb.append("    startAcwTime: ").append(this.toIndentedString(this.startAcwTime)).append("\n");
        sb.append("    endAcwTime: ").append(this.toIndentedString(this.endAcwTime)).append("\n");
        sb.append("    cobrowseSessionId: ").append(this.toIndentedString(this.cobrowseSessionId)).append("\n");
        sb.append("    cobrowseRole: ").append(this.toIndentedString(this.cobrowseRole)).append("\n");
        sb.append("    controlling: ").append(this.toIndentedString(this.controlling)).append("\n");
        sb.append("    viewerUrl: ").append(this.toIndentedString(this.viewerUrl)).append("\n");
        sb.append("    providerEventTime: ").append(this.toIndentedString(this.providerEventTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

