/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Recipient;
import java.util.HashMap;
import java.util.Map;

public class PutRoutingMessageRecipientRequest {
    private String recipientId;
    private Recipient body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PutRoutingMessageRecipientRequest withRecipientId(String recipientId) {
        this.setRecipientId(recipientId);
        return this;
    }

    public Recipient getBody() {
        return this.body;
    }

    public void setBody(Recipient body) {
        this.body = body;
    }

    public PutRoutingMessageRecipientRequest withBody(Recipient body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingMessageRecipientRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Recipient> withHttpInfo() {
        if (this.recipientId == null) {
            throw new IllegalStateException("Missing the required parameter 'recipientId' when building request for PutRoutingMessageRecipientRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingMessageRecipientRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/message/recipients/{recipientId}").withPathParameter("recipientId", this.recipientId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String recipientId, Recipient body) {
        return new Builder().withRequiredParams(recipientId, body);
    }

    public static class Builder {
        private final PutRoutingMessageRecipientRequest request = new PutRoutingMessageRecipientRequest();

        private Builder() {
        }

        public Builder withRecipientId(String recipientId) {
            this.request.setRecipientId(recipientId);
            return this;
        }

        public Builder withBody(Recipient body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String recipientId, Recipient body) {
            this.request.setRecipientId(recipientId);
            this.request.setBody(body);
            return this;
        }

        public PutRoutingMessageRecipientRequest build() {
            if (this.request.recipientId == null) {
                throw new IllegalStateException("Missing the required parameter 'recipientId' when building request for PutRoutingMessageRecipientRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingMessageRecipientRequest.");
            }
            return this.request;
        }
    }
}

