/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.IntradayMetric;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class IntradayQueryDataCommand
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private List<IntradayMetric> metrics = new ArrayList<IntradayMetric>();
    private List<String> queueIds = new ArrayList<String>();
    private Integer intervalLengthMinutes = null;

    public IntradayQueryDataCommand startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Start date of the requested date range in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public IntradayQueryDataCommand endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="End date of the requested date range in ISO-8601 format.  Must be within the same 7 day schedule week as defined by the management unit's start day of week")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public IntradayQueryDataCommand metrics(List<IntradayMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metrics to validate")
    @JsonProperty(value="metrics")
    public List<IntradayMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<IntradayMetric> metrics) {
        this.metrics = metrics;
    }

    public IntradayQueryDataCommand queueIds(List<String> queueIds) {
        this.queueIds = queueIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue IDs for which to fetch data.  Omitting or passing an empty list will return all available queues")
    @JsonProperty(value="queueIds")
    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(List<String> queueIds) {
        this.queueIds = queueIds;
    }

    public IntradayQueryDataCommand intervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The period/interval for which to aggregate the data.  Optional, defaults to 15")
    @JsonProperty(value="intervalLengthMinutes")
    public Integer getIntervalLengthMinutes() {
        return this.intervalLengthMinutes;
    }

    public void setIntervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntradayQueryDataCommand intradayQueryDataCommand = (IntradayQueryDataCommand)o;
        return Objects.equals(this.startDate, intradayQueryDataCommand.startDate) && Objects.equals(this.endDate, intradayQueryDataCommand.endDate) && Objects.equals(this.metrics, intradayQueryDataCommand.metrics) && Objects.equals(this.queueIds, intradayQueryDataCommand.queueIds) && Objects.equals(this.intervalLengthMinutes, intradayQueryDataCommand.intervalLengthMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.metrics, this.queueIds, this.intervalLengthMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntradayQueryDataCommand {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    queueIds: ").append(this.toIndentedString(this.queueIds)).append("\n");
        sb.append("    intervalLengthMinutes: ").append(this.toIndentedString(this.intervalLengthMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

