/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.apache;

import java.security.Principal;
import java.util.HashMap;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

public class ApacheHttpCredentialsProvider
implements CredentialsProvider {
    private HashMap<AuthScope, Credentials> map = new HashMap();

    public ApacheHttpCredentialsProvider(String hostname, int port, String user, String pass) {
        PrincipalWrapper principalWrapper = new PrincipalWrapper(user);
        this.setCredentials(new AuthScope(hostname, port), new CredentialsWrapper(principalWrapper, pass));
    }

    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.map.put(authScope, credentials);
    }

    public Credentials getCredentials(AuthScope authScope) {
        return this.map.get(authScope);
    }

    public void clear() {
        this.map.clear();
    }

    private class PrincipalWrapper
    implements Principal {
        private String name;

        public PrincipalWrapper(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private class CredentialsWrapper
    implements Credentials {
        private Principal principal;
        private String pass;

        public CredentialsWrapper(Principal principal, String pass) {
            this.principal = principal;
            this.pass = pass;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public String getPassword() {
            return this.pass;
        }
    }
}

