/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.apache;

import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpResponse
implements ApiClientConnectorResponse {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheHttpResponse.class);
    private final CloseableHttpResponse response;

    public ApacheHttpResponse(CloseableHttpResponse response) {
        this.response = response;
        HttpEntity entity = response.getEntity();
        if (entity != null && !entity.isRepeatable()) {
            try {
                response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            catch (Exception exception) {
                LOG.error("Failed to buffer HTTP entity.", (Throwable)exception);
            }
        }
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public boolean hasBody() {
        HttpEntity entity = this.response.getEntity();
        return entity != null && entity.getContentLength() != 0L;
    }

    @Override
    public InputStream getBody() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    @Override
    public String readBody() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) : null;
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : this.response.getAllHeaders()) {
            map.put(header.getName(), header.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void close() throws Exception {
        this.response.close();
    }
}

