/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationRecordingAnnotationsRequest {
    private String conversationId;
    private String recordingId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationRecordingAnnotationsRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public GetConversationRecordingAnnotationsRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationRecordingAnnotationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingAnnotationsRequest.");
        }
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingAnnotationsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/recordings/{recordingId}/annotations").withPathParameter("conversationId", this.conversationId).withPathParameter("recordingId", this.recordingId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String recordingId) {
        return new Builder().withRequiredParams(conversationId, recordingId);
    }

    public static class Builder {
        private final GetConversationRecordingAnnotationsRequest request = new GetConversationRecordingAnnotationsRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String recordingId) {
            this.request.setConversationId(conversationId);
            this.request.setRecordingId(recordingId);
            return this;
        }

        public GetConversationRecordingAnnotationsRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingAnnotationsRequest.");
            }
            if (this.request.recordingId == null) {
                throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingAnnotationsRequest.");
            }
            return this.request;
        }
    }
}

