/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Activity configured for shift in work plan")
public class CreateWorkPlanActivity
implements Serializable {
    private String activityCodeId = null;
    private String description = null;
    private Integer lengthMinutes = null;
    private Boolean startTimeIsRelativeToShiftStart = null;
    private Boolean flexibleStartTime = null;
    private Integer earliestStartTimeMinutes = null;
    private Integer latestStartTimeMinutes = null;
    private Integer exactStartTimeMinutes = null;
    private Integer startTimeIncrementMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsContiguousWorkTime = null;

    public CreateWorkPlanActivity activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the activity code associated with this activity")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public CreateWorkPlanActivity description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the activity")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWorkPlanActivity lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Length of the activity in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public CreateWorkPlanActivity startTimeIsRelativeToShiftStart(Boolean startTimeIsRelativeToShiftStart) {
        this.startTimeIsRelativeToShiftStart = startTimeIsRelativeToShiftStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the activity is relative to the start time of the shift it belongs to")
    @JsonProperty(value="startTimeIsRelativeToShiftStart")
    public Boolean getStartTimeIsRelativeToShiftStart() {
        return this.startTimeIsRelativeToShiftStart;
    }

    public void setStartTimeIsRelativeToShiftStart(Boolean startTimeIsRelativeToShiftStart) {
        this.startTimeIsRelativeToShiftStart = startTimeIsRelativeToShiftStart;
    }

    public CreateWorkPlanActivity flexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the activity is flexible")
    @JsonProperty(value="flexibleStartTime")
    public Boolean getFlexibleStartTime() {
        return this.flexibleStartTime;
    }

    public void setFlexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
    }

    public CreateWorkPlanActivity earliestStartTimeMinutes(Integer earliestStartTimeMinutes) {
        this.earliestStartTimeMinutes = earliestStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Earliest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="earliestStartTimeMinutes")
    public Integer getEarliestStartTimeMinutes() {
        return this.earliestStartTimeMinutes;
    }

    public void setEarliestStartTimeMinutes(Integer earliestStartTimeMinutes) {
        this.earliestStartTimeMinutes = earliestStartTimeMinutes;
    }

    public CreateWorkPlanActivity latestStartTimeMinutes(Integer latestStartTimeMinutes) {
        this.latestStartTimeMinutes = latestStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="latestStartTimeMinutes")
    public Integer getLatestStartTimeMinutes() {
        return this.latestStartTimeMinutes;
    }

    public void setLatestStartTimeMinutes(Integer latestStartTimeMinutes) {
        this.latestStartTimeMinutes = latestStartTimeMinutes;
    }

    public CreateWorkPlanActivity exactStartTimeMinutes(Integer exactStartTimeMinutes) {
        this.exactStartTimeMinutes = exactStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == false")
    @JsonProperty(value="exactStartTimeMinutes")
    public Integer getExactStartTimeMinutes() {
        return this.exactStartTimeMinutes;
    }

    public void setExactStartTimeMinutes(Integer exactStartTimeMinutes) {
        this.exactStartTimeMinutes = exactStartTimeMinutes;
    }

    public CreateWorkPlanActivity startTimeIncrementMinutes(Integer startTimeIncrementMinutes) {
        this.startTimeIncrementMinutes = startTimeIncrementMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Increment in offset minutes that would contribute to different possible start times for the activity")
    @JsonProperty(value="startTimeIncrementMinutes")
    public Integer getStartTimeIncrementMinutes() {
        return this.startTimeIncrementMinutes;
    }

    public void setStartTimeIncrementMinutes(Integer startTimeIncrementMinutes) {
        this.startTimeIncrementMinutes = startTimeIncrementMinutes;
    }

    public CreateWorkPlanActivity countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the activity is paid")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public CreateWorkPlanActivity countsAsContiguousWorkTime(Boolean countsAsContiguousWorkTime) {
        this.countsAsContiguousWorkTime = countsAsContiguousWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the activity duration is counted towards contiguous work time")
    @JsonProperty(value="countsAsContiguousWorkTime")
    public Boolean getCountsAsContiguousWorkTime() {
        return this.countsAsContiguousWorkTime;
    }

    public void setCountsAsContiguousWorkTime(Boolean countsAsContiguousWorkTime) {
        this.countsAsContiguousWorkTime = countsAsContiguousWorkTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkPlanActivity createWorkPlanActivity = (CreateWorkPlanActivity)o;
        return Objects.equals(this.activityCodeId, createWorkPlanActivity.activityCodeId) && Objects.equals(this.description, createWorkPlanActivity.description) && Objects.equals(this.lengthMinutes, createWorkPlanActivity.lengthMinutes) && Objects.equals(this.startTimeIsRelativeToShiftStart, createWorkPlanActivity.startTimeIsRelativeToShiftStart) && Objects.equals(this.flexibleStartTime, createWorkPlanActivity.flexibleStartTime) && Objects.equals(this.earliestStartTimeMinutes, createWorkPlanActivity.earliestStartTimeMinutes) && Objects.equals(this.latestStartTimeMinutes, createWorkPlanActivity.latestStartTimeMinutes) && Objects.equals(this.exactStartTimeMinutes, createWorkPlanActivity.exactStartTimeMinutes) && Objects.equals(this.startTimeIncrementMinutes, createWorkPlanActivity.startTimeIncrementMinutes) && Objects.equals(this.countsAsPaidTime, createWorkPlanActivity.countsAsPaidTime) && Objects.equals(this.countsAsContiguousWorkTime, createWorkPlanActivity.countsAsContiguousWorkTime);
    }

    public int hashCode() {
        return Objects.hash(this.activityCodeId, this.description, this.lengthMinutes, this.startTimeIsRelativeToShiftStart, this.flexibleStartTime, this.earliestStartTimeMinutes, this.latestStartTimeMinutes, this.exactStartTimeMinutes, this.startTimeIncrementMinutes, this.countsAsPaidTime, this.countsAsContiguousWorkTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkPlanActivity {\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    startTimeIsRelativeToShiftStart: ").append(this.toIndentedString(this.startTimeIsRelativeToShiftStart)).append("\n");
        sb.append("    flexibleStartTime: ").append(this.toIndentedString(this.flexibleStartTime)).append("\n");
        sb.append("    earliestStartTimeMinutes: ").append(this.toIndentedString(this.earliestStartTimeMinutes)).append("\n");
        sb.append("    latestStartTimeMinutes: ").append(this.toIndentedString(this.latestStartTimeMinutes)).append("\n");
        sb.append("    exactStartTimeMinutes: ").append(this.toIndentedString(this.exactStartTimeMinutes)).append("\n");
        sb.append("    startTimeIncrementMinutes: ").append(this.toIndentedString(this.startTimeIncrementMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsContiguousWorkTime: ").append(this.toIndentedString(this.countsAsContiguousWorkTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

