/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ExecuteRecordingJobsQuery;
import java.util.HashMap;
import java.util.Map;

public class PutRecordingJobRequest {
    private String jobId;
    private ExecuteRecordingJobsQuery body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public PutRecordingJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public ExecuteRecordingJobsQuery getBody() {
        return this.body;
    }

    public void setBody(ExecuteRecordingJobsQuery body) {
        this.body = body;
    }

    public PutRecordingJobRequest withBody(ExecuteRecordingJobsQuery body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRecordingJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ExecuteRecordingJobsQuery> withHttpInfo() {
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for PutRecordingJobRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRecordingJobRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/recording/jobs/{jobId}").withPathParameter("jobId", this.jobId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String jobId, ExecuteRecordingJobsQuery body) {
        return new Builder().withRequiredParams(jobId, body);
    }

    public static class Builder {
        private final PutRecordingJobRequest request = new PutRecordingJobRequest();

        private Builder() {
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withBody(ExecuteRecordingJobsQuery body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String jobId, ExecuteRecordingJobsQuery body) {
            this.request.setJobId(jobId);
            this.request.setBody(body);
            return this;
        }

        public PutRecordingJobRequest build() {
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for PutRecordingJobRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRecordingJobRequest.");
            }
            return this.request;
        }
    }
}

