/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CreateWorkPlanActivity;
import com.mypurecloud.sdk.v2.model.SetWrapperDayOfWeek;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Shift in a work plan")
public class CreateWorkPlanShift
implements Serializable {
    private String name = null;
    private SetWrapperDayOfWeek days = null;
    private Boolean flexibleStartTime = null;
    private Integer exactStartTimeMinutesFromMidnight = null;
    private Integer earliestStartTimeMinutesFromMidnight = null;
    private Integer latestStartTimeMinutesFromMidnight = null;
    private Boolean constrainStopTime = null;
    private Boolean constrainLatestStopTime = null;
    private Integer latestStopTimeMinutesFromMidnight = null;
    private Integer startIncrementMinutes = null;
    private Boolean flexiblePaidTime = null;
    private Integer exactPaidTimeMinutes = null;
    private Integer minimumPaidTimeMinutes = null;
    private Integer maximumPaidTimeMinutes = null;
    private Boolean constrainContiguousWorkTime = null;
    private Integer minimumContiguousWorkTimeMinutes = null;
    private Integer maximumContiguousWorkTimeMinutes = null;
    private List<CreateWorkPlanActivity> activities = new ArrayList<CreateWorkPlanActivity>();

    public CreateWorkPlanShift name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the shift")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkPlanShift days(SetWrapperDayOfWeek days) {
        this.days = days;
        return this;
    }

    @ApiModelProperty(example="null", value="Days of the week applicable for this shift")
    @JsonProperty(value="days")
    public SetWrapperDayOfWeek getDays() {
        return this.days;
    }

    public void setDays(SetWrapperDayOfWeek days) {
        this.days = days;
    }

    public CreateWorkPlanShift flexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the shift is flexible")
    @JsonProperty(value="flexibleStartTime")
    public Boolean getFlexibleStartTime() {
        return this.flexibleStartTime;
    }

    public void setFlexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
    }

    public CreateWorkPlanShift exactStartTimeMinutesFromMidnight(Integer exactStartTimeMinutesFromMidnight) {
        this.exactStartTimeMinutesFromMidnight = exactStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == false")
    @JsonProperty(value="exactStartTimeMinutesFromMidnight")
    public Integer getExactStartTimeMinutesFromMidnight() {
        return this.exactStartTimeMinutesFromMidnight;
    }

    public void setExactStartTimeMinutesFromMidnight(Integer exactStartTimeMinutesFromMidnight) {
        this.exactStartTimeMinutesFromMidnight = exactStartTimeMinutesFromMidnight;
    }

    public CreateWorkPlanShift earliestStartTimeMinutesFromMidnight(Integer earliestStartTimeMinutesFromMidnight) {
        this.earliestStartTimeMinutesFromMidnight = earliestStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Earliest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="earliestStartTimeMinutesFromMidnight")
    public Integer getEarliestStartTimeMinutesFromMidnight() {
        return this.earliestStartTimeMinutesFromMidnight;
    }

    public void setEarliestStartTimeMinutesFromMidnight(Integer earliestStartTimeMinutesFromMidnight) {
        this.earliestStartTimeMinutesFromMidnight = earliestStartTimeMinutesFromMidnight;
    }

    public CreateWorkPlanShift latestStartTimeMinutesFromMidnight(Integer latestStartTimeMinutesFromMidnight) {
        this.latestStartTimeMinutesFromMidnight = latestStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="latestStartTimeMinutesFromMidnight")
    public Integer getLatestStartTimeMinutesFromMidnight() {
        return this.latestStartTimeMinutesFromMidnight;
    }

    public void setLatestStartTimeMinutesFromMidnight(Integer latestStartTimeMinutesFromMidnight) {
        this.latestStartTimeMinutesFromMidnight = latestStartTimeMinutesFromMidnight;
    }

    public CreateWorkPlanShift constrainStopTime(Boolean constrainStopTime) {
        this.constrainStopTime = constrainStopTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the latest stop time constraint for the shift is enabled")
    @JsonProperty(value="constrainStopTime")
    public Boolean getConstrainStopTime() {
        return this.constrainStopTime;
    }

    public void setConstrainStopTime(Boolean constrainStopTime) {
        this.constrainStopTime = constrainStopTime;
    }

    public CreateWorkPlanShift constrainLatestStopTime(Boolean constrainLatestStopTime) {
        this.constrainLatestStopTime = constrainLatestStopTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the latest stop time constraint for the shift is enabled")
    @JsonProperty(value="constrainLatestStopTime")
    public Boolean getConstrainLatestStopTime() {
        return this.constrainLatestStopTime;
    }

    public void setConstrainLatestStopTime(Boolean constrainLatestStopTime) {
        this.constrainLatestStopTime = constrainLatestStopTime;
    }

    public CreateWorkPlanShift latestStopTimeMinutesFromMidnight(Integer latestStopTimeMinutesFromMidnight) {
        this.latestStopTimeMinutesFromMidnight = latestStopTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest stop time of the shift defined as offset minutes from midnight. Used if constrainStopTime == true")
    @JsonProperty(value="latestStopTimeMinutesFromMidnight")
    public Integer getLatestStopTimeMinutesFromMidnight() {
        return this.latestStopTimeMinutesFromMidnight;
    }

    public void setLatestStopTimeMinutesFromMidnight(Integer latestStopTimeMinutesFromMidnight) {
        this.latestStopTimeMinutesFromMidnight = latestStopTimeMinutesFromMidnight;
    }

    public CreateWorkPlanShift startIncrementMinutes(Integer startIncrementMinutes) {
        this.startIncrementMinutes = startIncrementMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Increment in offset minutes that would contribute to different possible start times for the shift. Used if flexibleStartTime == true")
    @JsonProperty(value="startIncrementMinutes")
    public Integer getStartIncrementMinutes() {
        return this.startIncrementMinutes;
    }

    public void setStartIncrementMinutes(Integer startIncrementMinutes) {
        this.startIncrementMinutes = startIncrementMinutes;
    }

    public CreateWorkPlanShift flexiblePaidTime(Boolean flexiblePaidTime) {
        this.flexiblePaidTime = flexiblePaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the paid time setting for the shift is flexible")
    @JsonProperty(value="flexiblePaidTime")
    public Boolean getFlexiblePaidTime() {
        return this.flexiblePaidTime;
    }

    public void setFlexiblePaidTime(Boolean flexiblePaidTime) {
        this.flexiblePaidTime = flexiblePaidTime;
    }

    public CreateWorkPlanShift exactPaidTimeMinutes(Integer exactPaidTimeMinutes) {
        this.exactPaidTimeMinutes = exactPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact paid time in minutes configured for the shift. Used if flexiblePaidTime == false")
    @JsonProperty(value="exactPaidTimeMinutes")
    public Integer getExactPaidTimeMinutes() {
        return this.exactPaidTimeMinutes;
    }

    public void setExactPaidTimeMinutes(Integer exactPaidTimeMinutes) {
        this.exactPaidTimeMinutes = exactPaidTimeMinutes;
    }

    public CreateWorkPlanShift minimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum paid time in minutes configured for the shift. Used if flexiblePaidTime == true")
    @JsonProperty(value="minimumPaidTimeMinutes")
    public Integer getMinimumPaidTimeMinutes() {
        return this.minimumPaidTimeMinutes;
    }

    public void setMinimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
    }

    public CreateWorkPlanShift maximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum paid time in minutes configured for the shift. Used if flexiblePaidTime == true")
    @JsonProperty(value="maximumPaidTimeMinutes")
    public Integer getMaximumPaidTimeMinutes() {
        return this.maximumPaidTimeMinutes;
    }

    public void setMaximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
    }

    public CreateWorkPlanShift constrainContiguousWorkTime(Boolean constrainContiguousWorkTime) {
        this.constrainContiguousWorkTime = constrainContiguousWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the contiguous time constraint for the shift is enabled")
    @JsonProperty(value="constrainContiguousWorkTime")
    public Boolean getConstrainContiguousWorkTime() {
        return this.constrainContiguousWorkTime;
    }

    public void setConstrainContiguousWorkTime(Boolean constrainContiguousWorkTime) {
        this.constrainContiguousWorkTime = constrainContiguousWorkTime;
    }

    public CreateWorkPlanShift minimumContiguousWorkTimeMinutes(Integer minimumContiguousWorkTimeMinutes) {
        this.minimumContiguousWorkTimeMinutes = minimumContiguousWorkTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true")
    @JsonProperty(value="minimumContiguousWorkTimeMinutes")
    public Integer getMinimumContiguousWorkTimeMinutes() {
        return this.minimumContiguousWorkTimeMinutes;
    }

    public void setMinimumContiguousWorkTimeMinutes(Integer minimumContiguousWorkTimeMinutes) {
        this.minimumContiguousWorkTimeMinutes = minimumContiguousWorkTimeMinutes;
    }

    public CreateWorkPlanShift maximumContiguousWorkTimeMinutes(Integer maximumContiguousWorkTimeMinutes) {
        this.maximumContiguousWorkTimeMinutes = maximumContiguousWorkTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true")
    @JsonProperty(value="maximumContiguousWorkTimeMinutes")
    public Integer getMaximumContiguousWorkTimeMinutes() {
        return this.maximumContiguousWorkTimeMinutes;
    }

    public void setMaximumContiguousWorkTimeMinutes(Integer maximumContiguousWorkTimeMinutes) {
        this.maximumContiguousWorkTimeMinutes = maximumContiguousWorkTimeMinutes;
    }

    public CreateWorkPlanShift activities(List<CreateWorkPlanActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="Activities configured for this shift")
    @JsonProperty(value="activities")
    public List<CreateWorkPlanActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<CreateWorkPlanActivity> activities) {
        this.activities = activities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkPlanShift createWorkPlanShift = (CreateWorkPlanShift)o;
        return Objects.equals(this.name, createWorkPlanShift.name) && Objects.equals(this.days, createWorkPlanShift.days) && Objects.equals(this.flexibleStartTime, createWorkPlanShift.flexibleStartTime) && Objects.equals(this.exactStartTimeMinutesFromMidnight, createWorkPlanShift.exactStartTimeMinutesFromMidnight) && Objects.equals(this.earliestStartTimeMinutesFromMidnight, createWorkPlanShift.earliestStartTimeMinutesFromMidnight) && Objects.equals(this.latestStartTimeMinutesFromMidnight, createWorkPlanShift.latestStartTimeMinutesFromMidnight) && Objects.equals(this.constrainStopTime, createWorkPlanShift.constrainStopTime) && Objects.equals(this.constrainLatestStopTime, createWorkPlanShift.constrainLatestStopTime) && Objects.equals(this.latestStopTimeMinutesFromMidnight, createWorkPlanShift.latestStopTimeMinutesFromMidnight) && Objects.equals(this.startIncrementMinutes, createWorkPlanShift.startIncrementMinutes) && Objects.equals(this.flexiblePaidTime, createWorkPlanShift.flexiblePaidTime) && Objects.equals(this.exactPaidTimeMinutes, createWorkPlanShift.exactPaidTimeMinutes) && Objects.equals(this.minimumPaidTimeMinutes, createWorkPlanShift.minimumPaidTimeMinutes) && Objects.equals(this.maximumPaidTimeMinutes, createWorkPlanShift.maximumPaidTimeMinutes) && Objects.equals(this.constrainContiguousWorkTime, createWorkPlanShift.constrainContiguousWorkTime) && Objects.equals(this.minimumContiguousWorkTimeMinutes, createWorkPlanShift.minimumContiguousWorkTimeMinutes) && Objects.equals(this.maximumContiguousWorkTimeMinutes, createWorkPlanShift.maximumContiguousWorkTimeMinutes) && Objects.equals(this.activities, createWorkPlanShift.activities);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.days, this.flexibleStartTime, this.exactStartTimeMinutesFromMidnight, this.earliestStartTimeMinutesFromMidnight, this.latestStartTimeMinutesFromMidnight, this.constrainStopTime, this.constrainLatestStopTime, this.latestStopTimeMinutesFromMidnight, this.startIncrementMinutes, this.flexiblePaidTime, this.exactPaidTimeMinutes, this.minimumPaidTimeMinutes, this.maximumPaidTimeMinutes, this.constrainContiguousWorkTime, this.minimumContiguousWorkTimeMinutes, this.maximumContiguousWorkTimeMinutes, this.activities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkPlanShift {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    days: ").append(this.toIndentedString(this.days)).append("\n");
        sb.append("    flexibleStartTime: ").append(this.toIndentedString(this.flexibleStartTime)).append("\n");
        sb.append("    exactStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.exactStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    earliestStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.earliestStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    latestStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.latestStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    constrainStopTime: ").append(this.toIndentedString(this.constrainStopTime)).append("\n");
        sb.append("    constrainLatestStopTime: ").append(this.toIndentedString(this.constrainLatestStopTime)).append("\n");
        sb.append("    latestStopTimeMinutesFromMidnight: ").append(this.toIndentedString(this.latestStopTimeMinutesFromMidnight)).append("\n");
        sb.append("    startIncrementMinutes: ").append(this.toIndentedString(this.startIncrementMinutes)).append("\n");
        sb.append("    flexiblePaidTime: ").append(this.toIndentedString(this.flexiblePaidTime)).append("\n");
        sb.append("    exactPaidTimeMinutes: ").append(this.toIndentedString(this.exactPaidTimeMinutes)).append("\n");
        sb.append("    minimumPaidTimeMinutes: ").append(this.toIndentedString(this.minimumPaidTimeMinutes)).append("\n");
        sb.append("    maximumPaidTimeMinutes: ").append(this.toIndentedString(this.maximumPaidTimeMinutes)).append("\n");
        sb.append("    constrainContiguousWorkTime: ").append(this.toIndentedString(this.constrainContiguousWorkTime)).append("\n");
        sb.append("    minimumContiguousWorkTimeMinutes: ").append(this.toIndentedString(this.minimumContiguousWorkTimeMinutes)).append("\n");
        sb.append("    maximumContiguousWorkTimeMinutes: ").append(this.toIndentedString(this.maximumContiguousWorkTimeMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

