/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetGdprRequestRequest;
import com.mypurecloud.sdk.v2.api.request.GetGdprRequestsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGdprSubjectsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGdprRequestsRequest;
import com.mypurecloud.sdk.v2.model.GDPRRequest;
import com.mypurecloud.sdk.v2.model.GDPRRequestEntityListing;
import com.mypurecloud.sdk.v2.model.GDPRSubjectEntityListing;
import java.io.IOException;

public class GeneralDataProtectionRegulationApi {
    private final ApiClient pcapiClient;

    public GeneralDataProtectionRegulationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GeneralDataProtectionRegulationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public GDPRRequest getGdprRequest(String requestId) throws IOException, ApiException {
        return this.getGdprRequest(this.createGetGdprRequestRequest(requestId));
    }

    public ApiResponse<GDPRRequest> getGdprRequestWithHttpInfo(String requestId) throws IOException {
        return this.getGdprRequest(this.createGetGdprRequestRequest(requestId).withHttpInfo());
    }

    private GetGdprRequestRequest createGetGdprRequestRequest(String requestId) {
        return GetGdprRequestRequest.builder().withRequestId(requestId).build();
    }

    public GDPRRequest getGdprRequest(GetGdprRequestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GDPRRequest> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GDPRRequest>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GDPRRequest> getGdprRequest(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GDPRRequest>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GDPRRequestEntityListing getGdprRequests(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getGdprRequests(this.createGetGdprRequestsRequest(pageSize, pageNumber));
    }

    public ApiResponse<GDPRRequestEntityListing> getGdprRequestsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getGdprRequests(this.createGetGdprRequestsRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetGdprRequestsRequest createGetGdprRequestsRequest(Integer pageSize, Integer pageNumber) {
        return GetGdprRequestsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public GDPRRequestEntityListing getGdprRequests(GetGdprRequestsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GDPRRequestEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GDPRRequestEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GDPRRequestEntityListing> getGdprRequests(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GDPRRequestEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GDPRSubjectEntityListing getGdprSubjects(String searchType, String searchValue) throws IOException, ApiException {
        return this.getGdprSubjects(this.createGetGdprSubjectsRequest(searchType, searchValue));
    }

    public ApiResponse<GDPRSubjectEntityListing> getGdprSubjectsWithHttpInfo(String searchType, String searchValue) throws IOException {
        return this.getGdprSubjects(this.createGetGdprSubjectsRequest(searchType, searchValue).withHttpInfo());
    }

    private GetGdprSubjectsRequest createGetGdprSubjectsRequest(String searchType, String searchValue) {
        return GetGdprSubjectsRequest.builder().withSearchType(searchType).withSearchValue(searchValue).build();
    }

    public GDPRSubjectEntityListing getGdprSubjects(GetGdprSubjectsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GDPRSubjectEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GDPRSubjectEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GDPRSubjectEntityListing> getGdprSubjects(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GDPRSubjectEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GDPRRequest postGdprRequests(GDPRRequest body, Boolean deleteConfirmed) throws IOException, ApiException {
        return this.postGdprRequests(this.createPostGdprRequestsRequest(body, deleteConfirmed));
    }

    public ApiResponse<GDPRRequest> postGdprRequestsWithHttpInfo(GDPRRequest body, Boolean deleteConfirmed) throws IOException {
        return this.postGdprRequests(this.createPostGdprRequestsRequest(body, deleteConfirmed).withHttpInfo());
    }

    private PostGdprRequestsRequest createPostGdprRequestsRequest(GDPRRequest body, Boolean deleteConfirmed) {
        return PostGdprRequestsRequest.builder().withBody(body).withDeleteConfirmed(deleteConfirmed).build();
    }

    public GDPRRequest postGdprRequests(PostGdprRequestsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GDPRRequest> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GDPRRequest>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GDPRRequest> postGdprRequests(ApiRequest<GDPRRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GDPRRequest>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

