/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsConversationSegment;
import com.mypurecloud.sdk.v2.model.AnalyticsFlow;
import com.mypurecloud.sdk.v2.model.AnalyticsMediaEndpointStat;
import com.mypurecloud.sdk.v2.model.AnalyticsSessionMetric;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AnalyticsSession
implements Serializable {
    private MediaTypeEnum mediaType = null;
    private String sessionId = null;
    private String addressOther = null;
    private String addressSelf = null;
    private String addressFrom = null;
    private String addressTo = null;
    private MessageTypeEnum messageType = null;
    private String ani = null;
    private DirectionEnum direction = null;
    private String dnis = null;
    private String sessionDnis = null;
    private String outboundCampaignId = null;
    private String outboundContactId = null;
    private String outboundContactListId = null;
    private String dispositionAnalyzer = null;
    private String dispositionName = null;
    private String edgeId = null;
    private String remoteNameDisplayable = null;
    private String roomId = null;
    private String monitoredSessionId = null;
    private String monitoredParticipantId = null;
    private String callbackUserName = null;
    private List<String> callbackNumbers = new ArrayList<String>();
    private Date callbackScheduledTime = null;
    private String scriptId = null;
    private String peerId = null;
    private Boolean skipEnabled = null;
    private Integer timeoutSeconds = null;
    private String cobrowseRole = null;
    private String cobrowseRoomId = null;
    private String mediaBridgeId = null;
    private String screenShareAddressSelf = null;
    private Boolean sharingScreen = null;
    private String screenShareRoomId = null;
    private String videoRoomId = null;
    private String videoAddressSelf = null;
    private List<AnalyticsConversationSegment> segments = new ArrayList<AnalyticsConversationSegment>();
    private List<AnalyticsSessionMetric> metrics = new ArrayList<AnalyticsSessionMetric>();
    private AnalyticsFlow flow = null;
    private List<AnalyticsMediaEndpointStat> mediaEndpointStats = new ArrayList<AnalyticsMediaEndpointStat>();
    private Boolean recording = null;
    private String journeyCustomerId = null;
    private String journeyCustomerIdType = null;
    private String journeyCustomerSessionId = null;
    private String journeyCustomerSessionIdType = null;
    private String journeyActionId = null;
    private String journeyActionMapId = null;
    private String journeyActionMapVersion = null;
    private String protocolCallId = null;
    private String provider = null;
    private String remote = null;

    public AnalyticsSession mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The session media type")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public AnalyticsSession sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of this session")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public AnalyticsSession addressOther(String addressOther) {
        this.addressOther = addressOther;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addressOther")
    public String getAddressOther() {
        return this.addressOther;
    }

    public void setAddressOther(String addressOther) {
        this.addressOther = addressOther;
    }

    public AnalyticsSession addressSelf(String addressSelf) {
        this.addressSelf = addressSelf;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addressSelf")
    public String getAddressSelf() {
        return this.addressSelf;
    }

    public void setAddressSelf(String addressSelf) {
        this.addressSelf = addressSelf;
    }

    public AnalyticsSession addressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addressFrom")
    public String getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
    }

    public AnalyticsSession addressTo(String addressTo) {
        this.addressTo = addressTo;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="addressTo")
    public String getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(String addressTo) {
        this.addressTo = addressTo;
    }

    public AnalyticsSession messageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
        return this;
    }

    @ApiModelProperty(example="null", value="Message type for messaging services such as sms")
    @JsonProperty(value="messageType")
    public MessageTypeEnum getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageTypeEnum messageType) {
        this.messageType = messageType;
    }

    public AnalyticsSession ani(String ani) {
        this.ani = ani;
        return this;
    }

    @ApiModelProperty(example="null", value="Automatic Number Identification (caller's number)")
    @JsonProperty(value="ani")
    public String getAni() {
        return this.ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public AnalyticsSession direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="Direction")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public AnalyticsSession dnis(String dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="Dialed number identification service (number dialed by the calling party)")
    @JsonProperty(value="dnis")
    public String getDnis() {
        return this.dnis;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public AnalyticsSession sessionDnis(String sessionDnis) {
        this.sessionDnis = sessionDnis;
        return this;
    }

    @ApiModelProperty(example="null", value="Dialed number for the current session; this can be different from dnis, e.g. if the call was transferred")
    @JsonProperty(value="sessionDnis")
    public String getSessionDnis() {
        return this.sessionDnis;
    }

    public void setSessionDnis(String sessionDnis) {
        this.sessionDnis = sessionDnis;
    }

    public AnalyticsSession outboundCampaignId(String outboundCampaignId) {
        this.outboundCampaignId = outboundCampaignId;
        return this;
    }

    @ApiModelProperty(example="null", value="(Dialer) Unique identifier of the outbound campaign")
    @JsonProperty(value="outboundCampaignId")
    public String getOutboundCampaignId() {
        return this.outboundCampaignId;
    }

    public void setOutboundCampaignId(String outboundCampaignId) {
        this.outboundCampaignId = outboundCampaignId;
    }

    public AnalyticsSession outboundContactId(String outboundContactId) {
        this.outboundContactId = outboundContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="(Dialer) Unique identifier of the contact")
    @JsonProperty(value="outboundContactId")
    public String getOutboundContactId() {
        return this.outboundContactId;
    }

    public void setOutboundContactId(String outboundContactId) {
        this.outboundContactId = outboundContactId;
    }

    public AnalyticsSession outboundContactListId(String outboundContactListId) {
        this.outboundContactListId = outboundContactListId;
        return this;
    }

    @ApiModelProperty(example="null", value="(Dialer) Unique identifier of the contact list that this contact belongs to")
    @JsonProperty(value="outboundContactListId")
    public String getOutboundContactListId() {
        return this.outboundContactListId;
    }

    public void setOutboundContactListId(String outboundContactListId) {
        this.outboundContactListId = outboundContactListId;
    }

    public AnalyticsSession dispositionAnalyzer(String dispositionAnalyzer) {
        this.dispositionAnalyzer = dispositionAnalyzer;
        return this;
    }

    @ApiModelProperty(example="null", value="(Dialer) Unique identifier of the contact list that this contact belongs to")
    @JsonProperty(value="dispositionAnalyzer")
    public String getDispositionAnalyzer() {
        return this.dispositionAnalyzer;
    }

    public void setDispositionAnalyzer(String dispositionAnalyzer) {
        this.dispositionAnalyzer = dispositionAnalyzer;
    }

    public AnalyticsSession dispositionName(String dispositionName) {
        this.dispositionName = dispositionName;
        return this;
    }

    @ApiModelProperty(example="disposition.classification.callable.machine", value="(Dialer) Result of the analysis")
    @JsonProperty(value="dispositionName")
    public String getDispositionName() {
        return this.dispositionName;
    }

    public void setDispositionName(String dispositionName) {
        this.dispositionName = dispositionName;
    }

    public AnalyticsSession edgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier of the edge device")
    @JsonProperty(value="edgeId")
    public String getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public AnalyticsSession remoteNameDisplayable(String remoteNameDisplayable) {
        this.remoteNameDisplayable = remoteNameDisplayable;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="remoteNameDisplayable")
    public String getRemoteNameDisplayable() {
        return this.remoteNameDisplayable;
    }

    public void setRemoteNameDisplayable(String remoteNameDisplayable) {
        this.remoteNameDisplayable = remoteNameDisplayable;
    }

    public AnalyticsSession roomId(String roomId) {
        this.roomId = roomId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the room")
    @JsonProperty(value="roomId")
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public AnalyticsSession monitoredSessionId(String monitoredSessionId) {
        this.monitoredSessionId = monitoredSessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The sessionID being monitored")
    @JsonProperty(value="monitoredSessionId")
    public String getMonitoredSessionId() {
        return this.monitoredSessionId;
    }

    public void setMonitoredSessionId(String monitoredSessionId) {
        this.monitoredSessionId = monitoredSessionId;
    }

    public AnalyticsSession monitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="monitoredParticipantId")
    public String getMonitoredParticipantId() {
        return this.monitoredParticipantId;
    }

    public void setMonitoredParticipantId(String monitoredParticipantId) {
        this.monitoredParticipantId = monitoredParticipantId;
    }

    public AnalyticsSession callbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the user requesting a call back")
    @JsonProperty(value="callbackUserName")
    public String getCallbackUserName() {
        return this.callbackUserName;
    }

    public void setCallbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
    }

    public AnalyticsSession callbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of numbers to callback")
    @JsonProperty(value="callbackNumbers")
    public List<String> getCallbackNumbers() {
        return this.callbackNumbers;
    }

    public void setCallbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
    }

    public AnalyticsSession callbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Scheduled callback date/time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="callbackScheduledTime")
    public Date getCallbackScheduledTime() {
        return this.callbackScheduledTime;
    }

    public void setCallbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
    }

    public AnalyticsSession scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for a script")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public AnalyticsSession peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for a peer")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public AnalyticsSession skipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="(Dialer) Whether the agent can skip the dialer contact")
    @JsonProperty(value="skipEnabled")
    public Boolean getSkipEnabled() {
        return this.skipEnabled;
    }

    public void setSkipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
    }

    public AnalyticsSession timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds before PureCloud begins the call for a call back. 0 disables automatic calling")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public AnalyticsSession cobrowseRole(String cobrowseRole) {
        this.cobrowseRole = cobrowseRole;
        return this;
    }

    @ApiModelProperty(example="null", value="Describe side of the cobrowse (sharer or viewer)")
    @JsonProperty(value="cobrowseRole")
    public String getCobrowseRole() {
        return this.cobrowseRole;
    }

    public void setCobrowseRole(String cobrowseRole) {
        this.cobrowseRole = cobrowseRole;
    }

    public AnalyticsSession cobrowseRoomId(String cobrowseRoomId) {
        this.cobrowseRoomId = cobrowseRoomId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for a PureCloud Cobrowse room.")
    @JsonProperty(value="cobrowseRoomId")
    public String getCobrowseRoomId() {
        return this.cobrowseRoomId;
    }

    public void setCobrowseRoomId(String cobrowseRoomId) {
        this.cobrowseRoomId = cobrowseRoomId;
    }

    public AnalyticsSession mediaBridgeId(String mediaBridgeId) {
        this.mediaBridgeId = mediaBridgeId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="mediaBridgeId")
    public String getMediaBridgeId() {
        return this.mediaBridgeId;
    }

    public void setMediaBridgeId(String mediaBridgeId) {
        this.mediaBridgeId = mediaBridgeId;
    }

    public AnalyticsSession screenShareAddressSelf(String screenShareAddressSelf) {
        this.screenShareAddressSelf = screenShareAddressSelf;
        return this;
    }

    @ApiModelProperty(example="null", value="Direct ScreenShare address")
    @JsonProperty(value="screenShareAddressSelf")
    public String getScreenShareAddressSelf() {
        return this.screenShareAddressSelf;
    }

    public void setScreenShareAddressSelf(String screenShareAddressSelf) {
        this.screenShareAddressSelf = screenShareAddressSelf;
    }

    public AnalyticsSession sharingScreen(Boolean sharingScreen) {
        this.sharingScreen = sharingScreen;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag determining if screenShare is started or not (true/false)")
    @JsonProperty(value="sharingScreen")
    public Boolean getSharingScreen() {
        return this.sharingScreen;
    }

    public void setSharingScreen(Boolean sharingScreen) {
        this.sharingScreen = sharingScreen;
    }

    public AnalyticsSession screenShareRoomId(String screenShareRoomId) {
        this.screenShareRoomId = screenShareRoomId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for a PureCloud ScreenShare room.")
    @JsonProperty(value="screenShareRoomId")
    public String getScreenShareRoomId() {
        return this.screenShareRoomId;
    }

    public void setScreenShareRoomId(String screenShareRoomId) {
        this.screenShareRoomId = screenShareRoomId;
    }

    public AnalyticsSession videoRoomId(String videoRoomId) {
        this.videoRoomId = videoRoomId;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique identifier for a PureCloud video room.")
    @JsonProperty(value="videoRoomId")
    public String getVideoRoomId() {
        return this.videoRoomId;
    }

    public void setVideoRoomId(String videoRoomId) {
        this.videoRoomId = videoRoomId;
    }

    public AnalyticsSession videoAddressSelf(String videoAddressSelf) {
        this.videoAddressSelf = videoAddressSelf;
        return this;
    }

    @ApiModelProperty(example="null", value="Direct Video address")
    @JsonProperty(value="videoAddressSelf")
    public String getVideoAddressSelf() {
        return this.videoAddressSelf;
    }

    public void setVideoAddressSelf(String videoAddressSelf) {
        this.videoAddressSelf = videoAddressSelf;
    }

    public AnalyticsSession segments(List<AnalyticsConversationSegment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of segments for this session")
    @JsonProperty(value="segments")
    public List<AnalyticsConversationSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<AnalyticsConversationSegment> segments) {
        this.segments = segments;
    }

    public AnalyticsSession metrics(List<AnalyticsSessionMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="List of metrics for this session")
    @JsonProperty(value="metrics")
    public List<AnalyticsSessionMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<AnalyticsSessionMetric> metrics) {
        this.metrics = metrics;
    }

    public AnalyticsSession flow(AnalyticsFlow flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="IVR flow execution associated with this session")
    @JsonProperty(value="flow")
    public AnalyticsFlow getFlow() {
        return this.flow;
    }

    public void setFlow(AnalyticsFlow flow) {
        this.flow = flow;
    }

    public AnalyticsSession mediaEndpointStats(List<AnalyticsMediaEndpointStat> mediaEndpointStats) {
        this.mediaEndpointStats = mediaEndpointStats;
        return this;
    }

    @ApiModelProperty(example="null", value="Media endpoint stats associated with this session")
    @JsonProperty(value="mediaEndpointStats")
    public List<AnalyticsMediaEndpointStat> getMediaEndpointStats() {
        return this.mediaEndpointStats;
    }

    public void setMediaEndpointStats(List<AnalyticsMediaEndpointStat> mediaEndpointStats) {
        this.mediaEndpointStats = mediaEndpointStats;
    }

    public AnalyticsSession recording(Boolean recording) {
        this.recording = recording;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag determining if an audio recording was started or not")
    @JsonProperty(value="recording")
    public Boolean getRecording() {
        return this.recording;
    }

    public void setRecording(Boolean recording) {
        this.recording = recording;
    }

    public AnalyticsSession journeyCustomerId(String journeyCustomerId) {
        this.journeyCustomerId = journeyCustomerId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the journey customer")
    @JsonProperty(value="journeyCustomerId")
    public String getJourneyCustomerId() {
        return this.journeyCustomerId;
    }

    public void setJourneyCustomerId(String journeyCustomerId) {
        this.journeyCustomerId = journeyCustomerId;
    }

    public AnalyticsSession journeyCustomerIdType(String journeyCustomerIdType) {
        this.journeyCustomerIdType = journeyCustomerIdType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the journey customer ID")
    @JsonProperty(value="journeyCustomerIdType")
    public String getJourneyCustomerIdType() {
        return this.journeyCustomerIdType;
    }

    public void setJourneyCustomerIdType(String journeyCustomerIdType) {
        this.journeyCustomerIdType = journeyCustomerIdType;
    }

    public AnalyticsSession journeyCustomerSessionId(String journeyCustomerSessionId) {
        this.journeyCustomerSessionId = journeyCustomerSessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the journey customer session")
    @JsonProperty(value="journeyCustomerSessionId")
    public String getJourneyCustomerSessionId() {
        return this.journeyCustomerSessionId;
    }

    public void setJourneyCustomerSessionId(String journeyCustomerSessionId) {
        this.journeyCustomerSessionId = journeyCustomerSessionId;
    }

    public AnalyticsSession journeyCustomerSessionIdType(String journeyCustomerSessionIdType) {
        this.journeyCustomerSessionIdType = journeyCustomerSessionIdType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the journey customer session ID")
    @JsonProperty(value="journeyCustomerSessionIdType")
    public String getJourneyCustomerSessionIdType() {
        return this.journeyCustomerSessionIdType;
    }

    public void setJourneyCustomerSessionIdType(String journeyCustomerSessionIdType) {
        this.journeyCustomerSessionIdType = journeyCustomerSessionIdType;
    }

    public AnalyticsSession journeyActionId(String journeyActionId) {
        this.journeyActionId = journeyActionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey action ID")
    @JsonProperty(value="journeyActionId")
    public String getJourneyActionId() {
        return this.journeyActionId;
    }

    public void setJourneyActionId(String journeyActionId) {
        this.journeyActionId = journeyActionId;
    }

    public AnalyticsSession journeyActionMapId(String journeyActionMapId) {
        this.journeyActionMapId = journeyActionMapId;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey action map ID")
    @JsonProperty(value="journeyActionMapId")
    public String getJourneyActionMapId() {
        return this.journeyActionMapId;
    }

    public void setJourneyActionMapId(String journeyActionMapId) {
        this.journeyActionMapId = journeyActionMapId;
    }

    public AnalyticsSession journeyActionMapVersion(String journeyActionMapVersion) {
        this.journeyActionMapVersion = journeyActionMapVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey action map version")
    @JsonProperty(value="journeyActionMapVersion")
    public String getJourneyActionMapVersion() {
        return this.journeyActionMapVersion;
    }

    public void setJourneyActionMapVersion(String journeyActionMapVersion) {
        this.journeyActionMapVersion = journeyActionMapVersion;
    }

    public AnalyticsSession protocolCallId(String protocolCallId) {
        this.protocolCallId = protocolCallId;
        return this;
    }

    @ApiModelProperty(example="null", value="The original voice protocol call ID, e.g. a SIP call ID")
    @JsonProperty(value="protocolCallId")
    public String getProtocolCallId() {
        return this.protocolCallId;
    }

    public void setProtocolCallId(String protocolCallId) {
        this.protocolCallId = protocolCallId;
    }

    public AnalyticsSession provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public AnalyticsSession remote(String remote) {
        this.remote = remote;
        return this;
    }

    @ApiModelProperty(example="null", value="Name, phone number, or email address of the remote party.")
    @JsonProperty(value="remote")
    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsSession analyticsSession = (AnalyticsSession)o;
        return Objects.equals((Object)this.mediaType, (Object)analyticsSession.mediaType) && Objects.equals(this.sessionId, analyticsSession.sessionId) && Objects.equals(this.addressOther, analyticsSession.addressOther) && Objects.equals(this.addressSelf, analyticsSession.addressSelf) && Objects.equals(this.addressFrom, analyticsSession.addressFrom) && Objects.equals(this.addressTo, analyticsSession.addressTo) && Objects.equals((Object)this.messageType, (Object)analyticsSession.messageType) && Objects.equals(this.ani, analyticsSession.ani) && Objects.equals((Object)this.direction, (Object)analyticsSession.direction) && Objects.equals(this.dnis, analyticsSession.dnis) && Objects.equals(this.sessionDnis, analyticsSession.sessionDnis) && Objects.equals(this.outboundCampaignId, analyticsSession.outboundCampaignId) && Objects.equals(this.outboundContactId, analyticsSession.outboundContactId) && Objects.equals(this.outboundContactListId, analyticsSession.outboundContactListId) && Objects.equals(this.dispositionAnalyzer, analyticsSession.dispositionAnalyzer) && Objects.equals(this.dispositionName, analyticsSession.dispositionName) && Objects.equals(this.edgeId, analyticsSession.edgeId) && Objects.equals(this.remoteNameDisplayable, analyticsSession.remoteNameDisplayable) && Objects.equals(this.roomId, analyticsSession.roomId) && Objects.equals(this.monitoredSessionId, analyticsSession.monitoredSessionId) && Objects.equals(this.monitoredParticipantId, analyticsSession.monitoredParticipantId) && Objects.equals(this.callbackUserName, analyticsSession.callbackUserName) && Objects.equals(this.callbackNumbers, analyticsSession.callbackNumbers) && Objects.equals(this.callbackScheduledTime, analyticsSession.callbackScheduledTime) && Objects.equals(this.scriptId, analyticsSession.scriptId) && Objects.equals(this.peerId, analyticsSession.peerId) && Objects.equals(this.skipEnabled, analyticsSession.skipEnabled) && Objects.equals(this.timeoutSeconds, analyticsSession.timeoutSeconds) && Objects.equals(this.cobrowseRole, analyticsSession.cobrowseRole) && Objects.equals(this.cobrowseRoomId, analyticsSession.cobrowseRoomId) && Objects.equals(this.mediaBridgeId, analyticsSession.mediaBridgeId) && Objects.equals(this.screenShareAddressSelf, analyticsSession.screenShareAddressSelf) && Objects.equals(this.sharingScreen, analyticsSession.sharingScreen) && Objects.equals(this.screenShareRoomId, analyticsSession.screenShareRoomId) && Objects.equals(this.videoRoomId, analyticsSession.videoRoomId) && Objects.equals(this.videoAddressSelf, analyticsSession.videoAddressSelf) && Objects.equals(this.segments, analyticsSession.segments) && Objects.equals(this.metrics, analyticsSession.metrics) && Objects.equals(this.flow, analyticsSession.flow) && Objects.equals(this.mediaEndpointStats, analyticsSession.mediaEndpointStats) && Objects.equals(this.recording, analyticsSession.recording) && Objects.equals(this.journeyCustomerId, analyticsSession.journeyCustomerId) && Objects.equals(this.journeyCustomerIdType, analyticsSession.journeyCustomerIdType) && Objects.equals(this.journeyCustomerSessionId, analyticsSession.journeyCustomerSessionId) && Objects.equals(this.journeyCustomerSessionIdType, analyticsSession.journeyCustomerSessionIdType) && Objects.equals(this.journeyActionId, analyticsSession.journeyActionId) && Objects.equals(this.journeyActionMapId, analyticsSession.journeyActionMapId) && Objects.equals(this.journeyActionMapVersion, analyticsSession.journeyActionMapVersion) && Objects.equals(this.protocolCallId, analyticsSession.protocolCallId) && Objects.equals(this.provider, analyticsSession.provider) && Objects.equals(this.remote, analyticsSession.remote);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaType, this.sessionId, this.addressOther, this.addressSelf, this.addressFrom, this.addressTo, this.messageType, this.ani, this.direction, this.dnis, this.sessionDnis, this.outboundCampaignId, this.outboundContactId, this.outboundContactListId, this.dispositionAnalyzer, this.dispositionName, this.edgeId, this.remoteNameDisplayable, this.roomId, this.monitoredSessionId, this.monitoredParticipantId, this.callbackUserName, this.callbackNumbers, this.callbackScheduledTime, this.scriptId, this.peerId, this.skipEnabled, this.timeoutSeconds, this.cobrowseRole, this.cobrowseRoomId, this.mediaBridgeId, this.screenShareAddressSelf, this.sharingScreen, this.screenShareRoomId, this.videoRoomId, this.videoAddressSelf, this.segments, this.metrics, this.flow, this.mediaEndpointStats, this.recording, this.journeyCustomerId, this.journeyCustomerIdType, this.journeyCustomerSessionId, this.journeyCustomerSessionIdType, this.journeyActionId, this.journeyActionMapId, this.journeyActionMapVersion, this.protocolCallId, this.provider, this.remote});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsSession {\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    addressOther: ").append(this.toIndentedString(this.addressOther)).append("\n");
        sb.append("    addressSelf: ").append(this.toIndentedString(this.addressSelf)).append("\n");
        sb.append("    addressFrom: ").append(this.toIndentedString(this.addressFrom)).append("\n");
        sb.append("    addressTo: ").append(this.toIndentedString(this.addressTo)).append("\n");
        sb.append("    messageType: ").append(this.toIndentedString((Object)this.messageType)).append("\n");
        sb.append("    ani: ").append(this.toIndentedString(this.ani)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    sessionDnis: ").append(this.toIndentedString(this.sessionDnis)).append("\n");
        sb.append("    outboundCampaignId: ").append(this.toIndentedString(this.outboundCampaignId)).append("\n");
        sb.append("    outboundContactId: ").append(this.toIndentedString(this.outboundContactId)).append("\n");
        sb.append("    outboundContactListId: ").append(this.toIndentedString(this.outboundContactListId)).append("\n");
        sb.append("    dispositionAnalyzer: ").append(this.toIndentedString(this.dispositionAnalyzer)).append("\n");
        sb.append("    dispositionName: ").append(this.toIndentedString(this.dispositionName)).append("\n");
        sb.append("    edgeId: ").append(this.toIndentedString(this.edgeId)).append("\n");
        sb.append("    remoteNameDisplayable: ").append(this.toIndentedString(this.remoteNameDisplayable)).append("\n");
        sb.append("    roomId: ").append(this.toIndentedString(this.roomId)).append("\n");
        sb.append("    monitoredSessionId: ").append(this.toIndentedString(this.monitoredSessionId)).append("\n");
        sb.append("    monitoredParticipantId: ").append(this.toIndentedString(this.monitoredParticipantId)).append("\n");
        sb.append("    callbackUserName: ").append(this.toIndentedString(this.callbackUserName)).append("\n");
        sb.append("    callbackNumbers: ").append(this.toIndentedString(this.callbackNumbers)).append("\n");
        sb.append("    callbackScheduledTime: ").append(this.toIndentedString(this.callbackScheduledTime)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    skipEnabled: ").append(this.toIndentedString(this.skipEnabled)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("    cobrowseRole: ").append(this.toIndentedString(this.cobrowseRole)).append("\n");
        sb.append("    cobrowseRoomId: ").append(this.toIndentedString(this.cobrowseRoomId)).append("\n");
        sb.append("    mediaBridgeId: ").append(this.toIndentedString(this.mediaBridgeId)).append("\n");
        sb.append("    screenShareAddressSelf: ").append(this.toIndentedString(this.screenShareAddressSelf)).append("\n");
        sb.append("    sharingScreen: ").append(this.toIndentedString(this.sharingScreen)).append("\n");
        sb.append("    screenShareRoomId: ").append(this.toIndentedString(this.screenShareRoomId)).append("\n");
        sb.append("    videoRoomId: ").append(this.toIndentedString(this.videoRoomId)).append("\n");
        sb.append("    videoAddressSelf: ").append(this.toIndentedString(this.videoAddressSelf)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    mediaEndpointStats: ").append(this.toIndentedString(this.mediaEndpointStats)).append("\n");
        sb.append("    recording: ").append(this.toIndentedString(this.recording)).append("\n");
        sb.append("    journeyCustomerId: ").append(this.toIndentedString(this.journeyCustomerId)).append("\n");
        sb.append("    journeyCustomerIdType: ").append(this.toIndentedString(this.journeyCustomerIdType)).append("\n");
        sb.append("    journeyCustomerSessionId: ").append(this.toIndentedString(this.journeyCustomerSessionId)).append("\n");
        sb.append("    journeyCustomerSessionIdType: ").append(this.toIndentedString(this.journeyCustomerSessionIdType)).append("\n");
        sb.append("    journeyActionId: ").append(this.toIndentedString(this.journeyActionId)).append("\n");
        sb.append("    journeyActionMapId: ").append(this.toIndentedString(this.journeyActionMapId)).append("\n");
        sb.append("    journeyActionMapVersion: ").append(this.toIndentedString(this.journeyActionMapVersion)).append("\n");
        sb.append("    protocolCallId: ").append(this.toIndentedString(this.protocolCallId)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    remote: ").append(this.toIndentedString(this.remote)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MessageTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINE("line");

        private String value;

        private MessageTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessageTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessageTypeEnum value : MessageTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessageTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("voice"),
        CHAT("chat"),
        EMAIL("email"),
        CALLBACK("callback"),
        COBROWSE("cobrowse"),
        VIDEO("video"),
        SCREENSHARE("screenshare"),
        MESSAGE("message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

