/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Recording;
import java.util.HashMap;
import java.util.Map;

public class PutConversationRecordingRequest {
    private String conversationId;
    private String recordingId;
    private Recording body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PutConversationRecordingRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public PutConversationRecordingRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public Recording getBody() {
        return this.body;
    }

    public void setBody(Recording body) {
        this.body = body;
    }

    public PutConversationRecordingRequest withBody(Recording body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutConversationRecordingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Recording> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutConversationRecordingRequest.");
        }
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for PutConversationRecordingRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutConversationRecordingRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/conversations/{conversationId}/recordings/{recordingId}").withPathParameter("conversationId", this.conversationId).withPathParameter("recordingId", this.recordingId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String recordingId, Recording body) {
        return new Builder().withRequiredParams(conversationId, recordingId, body);
    }

    public static class Builder {
        private final PutConversationRecordingRequest request = new PutConversationRecordingRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withBody(Recording body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String recordingId, Recording body) {
            this.request.setConversationId(conversationId);
            this.request.setRecordingId(recordingId);
            this.request.setBody(body);
            return this;
        }

        public PutConversationRecordingRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PutConversationRecordingRequest.");
            }
            if (this.request.recordingId == null) {
                throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for PutConversationRecordingRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutConversationRecordingRequest.");
            }
            return this.request;
        }
    }
}

