/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="SCIM Error")
public class ScimError
implements Serializable {
    private String status = null;
    private ScimTypeEnum scimType = null;
    private String detail = null;
    private List<String> schemas = new ArrayList<String>();

    @ApiModelProperty(example="null", value="HTTP Status Code")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Optional SCIM Error Type when httpStatus is 400 error")
    @JsonProperty(value="scimType")
    public ScimTypeEnum getScimType() {
        return this.scimType;
    }

    @ApiModelProperty(example="null", value="Optional detailed error description")
    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    public ScimError schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="Schemas for the SCIM Error")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimError scimError = (ScimError)o;
        return Objects.equals(this.status, scimError.status) && Objects.equals((Object)this.scimType, (Object)scimError.scimType) && Objects.equals(this.detail, scimError.detail) && Objects.equals(this.schemas, scimError.schemas);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.scimType, this.detail, this.schemas});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimError {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    scimType: ").append(this.toIndentedString((Object)this.scimType)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScimTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INVALIDFILTER("invalidFilter"),
        TOOMANY("tooMany"),
        UNIQUENESS("uniqueness"),
        MUTABILITY("mutability"),
        INVALIDSYNTAX("invalidSyntax"),
        INVALIDPATH("invalidPath"),
        NOTARGET("noTarget"),
        INVALIDVALUE("invalidValue"),
        INVALIDVERS("invalidVers"),
        SENSITIVE("sensitive");

        private String value;

        private ScimTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScimTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScimTypeEnum value : ScimTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScimTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

