/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Activity configured for shift in work plan")
public class WorkPlanActivity
implements Serializable {
    private String activityCodeId = null;
    private String description = null;
    private Integer lengthMinutes = null;
    private Boolean startTimeIsRelativeToShiftStart = null;
    private Boolean flexibleStartTime = null;
    private Integer earliestStartTimeMinutes = null;
    private Integer latestStartTimeMinutes = null;
    private Integer exactStartTimeMinutes = null;
    private Integer startTimeIncrementMinutes = null;
    private Boolean countsAsPaidTime = null;
    private Boolean countsAsContiguousWorkTime = null;
    private String id = null;
    private Boolean delete = null;

    public WorkPlanActivity activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the activity code associated with this activity")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public WorkPlanActivity description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the activity")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkPlanActivity lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Length of the activity in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public WorkPlanActivity startTimeIsRelativeToShiftStart(Boolean startTimeIsRelativeToShiftStart) {
        this.startTimeIsRelativeToShiftStart = startTimeIsRelativeToShiftStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the activity is relative to the start time of the shift it belongs to")
    @JsonProperty(value="startTimeIsRelativeToShiftStart")
    public Boolean getStartTimeIsRelativeToShiftStart() {
        return this.startTimeIsRelativeToShiftStart;
    }

    public void setStartTimeIsRelativeToShiftStart(Boolean startTimeIsRelativeToShiftStart) {
        this.startTimeIsRelativeToShiftStart = startTimeIsRelativeToShiftStart;
    }

    public WorkPlanActivity flexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the activity is flexible")
    @JsonProperty(value="flexibleStartTime")
    public Boolean getFlexibleStartTime() {
        return this.flexibleStartTime;
    }

    public void setFlexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
    }

    public WorkPlanActivity earliestStartTimeMinutes(Integer earliestStartTimeMinutes) {
        this.earliestStartTimeMinutes = earliestStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Earliest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="earliestStartTimeMinutes")
    public Integer getEarliestStartTimeMinutes() {
        return this.earliestStartTimeMinutes;
    }

    public void setEarliestStartTimeMinutes(Integer earliestStartTimeMinutes) {
        this.earliestStartTimeMinutes = earliestStartTimeMinutes;
    }

    public WorkPlanActivity latestStartTimeMinutes(Integer latestStartTimeMinutes) {
        this.latestStartTimeMinutes = latestStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="latestStartTimeMinutes")
    public Integer getLatestStartTimeMinutes() {
        return this.latestStartTimeMinutes;
    }

    public void setLatestStartTimeMinutes(Integer latestStartTimeMinutes) {
        this.latestStartTimeMinutes = latestStartTimeMinutes;
    }

    public WorkPlanActivity exactStartTimeMinutes(Integer exactStartTimeMinutes) {
        this.exactStartTimeMinutes = exactStartTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact activity start in offset minutes relative to shift start time if startTimeIsRelativeToShiftStart == true else its based on midnight. Used if flexibleStartTime == false")
    @JsonProperty(value="exactStartTimeMinutes")
    public Integer getExactStartTimeMinutes() {
        return this.exactStartTimeMinutes;
    }

    public void setExactStartTimeMinutes(Integer exactStartTimeMinutes) {
        this.exactStartTimeMinutes = exactStartTimeMinutes;
    }

    public WorkPlanActivity startTimeIncrementMinutes(Integer startTimeIncrementMinutes) {
        this.startTimeIncrementMinutes = startTimeIncrementMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Increment in offset minutes that would contribute to different possible start times for the activity")
    @JsonProperty(value="startTimeIncrementMinutes")
    public Integer getStartTimeIncrementMinutes() {
        return this.startTimeIncrementMinutes;
    }

    public void setStartTimeIncrementMinutes(Integer startTimeIncrementMinutes) {
        this.startTimeIncrementMinutes = startTimeIncrementMinutes;
    }

    public WorkPlanActivity countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the activity is paid")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public WorkPlanActivity countsAsContiguousWorkTime(Boolean countsAsContiguousWorkTime) {
        this.countsAsContiguousWorkTime = countsAsContiguousWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the activity duration is counted towards contiguous work time")
    @JsonProperty(value="countsAsContiguousWorkTime")
    public Boolean getCountsAsContiguousWorkTime() {
        return this.countsAsContiguousWorkTime;
    }

    public void setCountsAsContiguousWorkTime(Boolean countsAsContiguousWorkTime) {
        this.countsAsContiguousWorkTime = countsAsContiguousWorkTime;
    }

    public WorkPlanActivity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the activity. This is required only for the case of updating an existing activity")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkPlanActivity delete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @ApiModelProperty(example="null", value="If marked true for updating an existing activity, the activity will be permanently deleted")
    @JsonProperty(value="delete")
    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanActivity workPlanActivity = (WorkPlanActivity)o;
        return Objects.equals(this.activityCodeId, workPlanActivity.activityCodeId) && Objects.equals(this.description, workPlanActivity.description) && Objects.equals(this.lengthMinutes, workPlanActivity.lengthMinutes) && Objects.equals(this.startTimeIsRelativeToShiftStart, workPlanActivity.startTimeIsRelativeToShiftStart) && Objects.equals(this.flexibleStartTime, workPlanActivity.flexibleStartTime) && Objects.equals(this.earliestStartTimeMinutes, workPlanActivity.earliestStartTimeMinutes) && Objects.equals(this.latestStartTimeMinutes, workPlanActivity.latestStartTimeMinutes) && Objects.equals(this.exactStartTimeMinutes, workPlanActivity.exactStartTimeMinutes) && Objects.equals(this.startTimeIncrementMinutes, workPlanActivity.startTimeIncrementMinutes) && Objects.equals(this.countsAsPaidTime, workPlanActivity.countsAsPaidTime) && Objects.equals(this.countsAsContiguousWorkTime, workPlanActivity.countsAsContiguousWorkTime) && Objects.equals(this.id, workPlanActivity.id) && Objects.equals(this.delete, workPlanActivity.delete);
    }

    public int hashCode() {
        return Objects.hash(this.activityCodeId, this.description, this.lengthMinutes, this.startTimeIsRelativeToShiftStart, this.flexibleStartTime, this.earliestStartTimeMinutes, this.latestStartTimeMinutes, this.exactStartTimeMinutes, this.startTimeIncrementMinutes, this.countsAsPaidTime, this.countsAsContiguousWorkTime, this.id, this.delete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanActivity {\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    startTimeIsRelativeToShiftStart: ").append(this.toIndentedString(this.startTimeIsRelativeToShiftStart)).append("\n");
        sb.append("    flexibleStartTime: ").append(this.toIndentedString(this.flexibleStartTime)).append("\n");
        sb.append("    earliestStartTimeMinutes: ").append(this.toIndentedString(this.earliestStartTimeMinutes)).append("\n");
        sb.append("    latestStartTimeMinutes: ").append(this.toIndentedString(this.latestStartTimeMinutes)).append("\n");
        sb.append("    exactStartTimeMinutes: ").append(this.toIndentedString(this.exactStartTimeMinutes)).append("\n");
        sb.append("    startTimeIncrementMinutes: ").append(this.toIndentedString(this.startTimeIncrementMinutes)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    countsAsContiguousWorkTime: ").append(this.toIndentedString(this.countsAsContiguousWorkTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    delete: ").append(this.toIndentedString(this.delete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

