/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetQualitySurveyRequest {
    private String surveyId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = surveyId;
    }

    public GetQualitySurveyRequest withSurveyId(String surveyId) {
        this.setSurveyId(surveyId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetQualitySurveyRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.surveyId == null) {
            throw new IllegalStateException("Missing the required parameter 'surveyId' when building request for GetQualitySurveyRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/quality/surveys/{surveyId}").withPathParameter("surveyId", this.surveyId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String surveyId) {
        return new Builder().withRequiredParams(surveyId);
    }

    public static class Builder {
        private final GetQualitySurveyRequest request = new GetQualitySurveyRequest();

        private Builder() {
        }

        public Builder withSurveyId(String surveyId) {
            this.request.setSurveyId(surveyId);
            return this;
        }

        public Builder withRequiredParams(String surveyId) {
            this.request.setSurveyId(surveyId);
            return this;
        }

        public GetQualitySurveyRequest build() {
            if (this.request.surveyId == null) {
                throw new IllegalStateException("Missing the required parameter 'surveyId' when building request for GetQualitySurveyRequest.");
            }
            return this.request;
        }
    }
}

