/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetContentmanagementDocumentRequest {
    private String documentId;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public GetContentmanagementDocumentRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetContentmanagementDocumentRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetContentmanagementDocumentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for GetContentmanagementDocumentRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/contentmanagement/documents/{documentId}").withPathParameter("documentId", this.documentId).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String documentId) {
        return new Builder().withRequiredParams(documentId);
    }

    public static class Builder {
        private final GetContentmanagementDocumentRequest request = new GetContentmanagementDocumentRequest();

        private Builder() {
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public GetContentmanagementDocumentRequest build() {
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for GetContentmanagementDocumentRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        LOCKINFO("lockInfo"),
        ACL("acl"),
        WORKSPACE("workspace");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

