/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ContactSort;
import com.mypurecloud.sdk.v2.model.PhoneColumn;
import com.mypurecloud.sdk.v2.model.RestErrorDetail;
import com.mypurecloud.sdk.v2.model.UriReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Campaign
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private UriReference contactList = null;
    private UriReference queue = null;
    private DialingModeEnum dialingMode = null;
    private UriReference script = null;
    private UriReference edgeGroup = null;
    private UriReference site = null;
    private CampaignStatusEnum campaignStatus = null;
    private List<PhoneColumn> phoneColumns = new ArrayList<PhoneColumn>();
    private Double abandonRate = null;
    private List<UriReference> dncLists = new ArrayList<UriReference>();
    private UriReference callableTimeSet = null;
    private UriReference callAnalysisResponseSet = null;
    private List<RestErrorDetail> errors = new ArrayList<RestErrorDetail>();
    private String callerName = null;
    private String callerAddress = null;
    private Integer outboundLineCount = null;
    private List<UriReference> ruleSets = new ArrayList<UriReference>();
    private Boolean skipPreviewDisabled = null;
    private Long previewTimeOutSeconds = null;
    private Boolean alwaysRunning = null;
    private ContactSort contactSort = null;
    private List<ContactSort> contactSorts = new ArrayList<ContactSort>();
    private Integer noAnswerTimeout = null;
    private String callAnalysisLanguage = null;
    private Integer priority = null;
    private List<UriReference> contactListFilters = new ArrayList<UriReference>();
    private UriReference division = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Campaign name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Campaign.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public Campaign version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Campaign contactList(UriReference contactList) {
        this.contactList = contactList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ContactList for this Campaign to dial.")
    @JsonProperty(value="contactList")
    public UriReference getContactList() {
        return this.contactList;
    }

    public void setContactList(UriReference contactList) {
        this.contactList = contactList;
    }

    public Campaign queue(UriReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The Queue for this Campaign to route calls to. Required for all dialing modes except agentless.")
    @JsonProperty(value="queue")
    public UriReference getQueue() {
        return this.queue;
    }

    public void setQueue(UriReference queue) {
        this.queue = queue;
    }

    public Campaign dialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The strategy this Campaign will use for dialing.")
    @JsonProperty(value="dialingMode")
    public DialingModeEnum getDialingMode() {
        return this.dialingMode;
    }

    public void setDialingMode(DialingModeEnum dialingMode) {
        this.dialingMode = dialingMode;
    }

    public Campaign script(UriReference script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Script to be displayed to agents that are handling outbound calls. Required for all dialing modes except agentless.")
    @JsonProperty(value="script")
    public UriReference getScript() {
        return this.script;
    }

    public void setScript(UriReference script) {
        this.script = script;
    }

    public Campaign edgeGroup(UriReference edgeGroup) {
        this.edgeGroup = edgeGroup;
        return this;
    }

    @ApiModelProperty(example="null", value="The EdgeGroup that will place the calls. Required for all dialing modes except preview.")
    @JsonProperty(value="edgeGroup")
    public UriReference getEdgeGroup() {
        return this.edgeGroup;
    }

    public void setEdgeGroup(UriReference edgeGroup) {
        this.edgeGroup = edgeGroup;
    }

    public Campaign site(UriReference site) {
        this.site = site;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier of the site to be used for dialing; can be set in place of an edge group.")
    @JsonProperty(value="site")
    public UriReference getSite() {
        return this.site;
    }

    public void setSite(UriReference site) {
        this.site = site;
    }

    public Campaign campaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The current status of the Campaign. A Campaign may be turned 'on' or 'off'. Required for updates.")
    @JsonProperty(value="campaignStatus")
    public CampaignStatusEnum getCampaignStatus() {
        return this.campaignStatus;
    }

    public void setCampaignStatus(CampaignStatusEnum campaignStatus) {
        this.campaignStatus = campaignStatus;
    }

    public Campaign phoneColumns(List<PhoneColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ContactPhoneNumberColumns on the ContactList that this Campaign should dial.")
    @JsonProperty(value="phoneColumns")
    public List<PhoneColumn> getPhoneColumns() {
        return this.phoneColumns;
    }

    public void setPhoneColumns(List<PhoneColumn> phoneColumns) {
        this.phoneColumns = phoneColumns;
    }

    public Campaign abandonRate(Double abandonRate) {
        this.abandonRate = abandonRate;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted abandon rate percentage. Required for progressive, power, and predictive campaigns.")
    @JsonProperty(value="abandonRate")
    public Double getAbandonRate() {
        return this.abandonRate;
    }

    public void setAbandonRate(Double abandonRate) {
        this.abandonRate = abandonRate;
    }

    public Campaign dncLists(List<UriReference> dncLists) {
        this.dncLists = dncLists;
        return this;
    }

    @ApiModelProperty(example="null", value="DncLists for this Campaign to check before placing a call.")
    @JsonProperty(value="dncLists")
    public List<UriReference> getDncLists() {
        return this.dncLists;
    }

    public void setDncLists(List<UriReference> dncLists) {
        this.dncLists = dncLists;
    }

    public Campaign callableTimeSet(UriReference callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
        return this;
    }

    @ApiModelProperty(example="null", value="The callable time set for this campaign to check before placing a call.")
    @JsonProperty(value="callableTimeSet")
    public UriReference getCallableTimeSet() {
        return this.callableTimeSet;
    }

    public void setCallableTimeSet(UriReference callableTimeSet) {
        this.callableTimeSet = callableTimeSet;
    }

    public Campaign callAnalysisResponseSet(UriReference callAnalysisResponseSet) {
        this.callAnalysisResponseSet = callAnalysisResponseSet;
        return this;
    }

    @ApiModelProperty(example="null", value="The call analysis response set to handle call analysis results from the edge. Required for all dialing modes except preview.")
    @JsonProperty(value="callAnalysisResponseSet")
    public UriReference getCallAnalysisResponseSet() {
        return this.callAnalysisResponseSet;
    }

    public void setCallAnalysisResponseSet(UriReference callAnalysisResponseSet) {
        this.callAnalysisResponseSet = callAnalysisResponseSet;
    }

    public Campaign errors(List<RestErrorDetail> errors) {
        this.errors = errors;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of current error conditions associated with the campaign.")
    @JsonProperty(value="errors")
    public List<RestErrorDetail> getErrors() {
        return this.errors;
    }

    public void setErrors(List<RestErrorDetail> errors) {
        this.errors = errors;
    }

    public Campaign callerName(String callerName) {
        this.callerName = callerName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The caller id name to be displayed on the outbound call.")
    @JsonProperty(value="callerName")
    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    public Campaign callerAddress(String callerAddress) {
        this.callerAddress = callerAddress;
        return this;
    }

    @ApiModelProperty(example="(555) 555-5555", required=true, value="The caller id phone number to be displayed on the outbound call.")
    @JsonProperty(value="callerAddress")
    public String getCallerAddress() {
        return this.callerAddress;
    }

    public void setCallerAddress(String callerAddress) {
        this.callerAddress = callerAddress;
    }

    public Campaign outboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of outbound lines to be concurrently dialed. Only applicable to non-preview campaigns; only required for agentless.")
    @JsonProperty(value="outboundLineCount")
    public Integer getOutboundLineCount() {
        return this.outboundLineCount;
    }

    public void setOutboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
    }

    public Campaign ruleSets(List<UriReference> ruleSets) {
        this.ruleSets = ruleSets;
        return this;
    }

    @ApiModelProperty(example="null", value="Rule sets to be applied while this campaign is dialing.")
    @JsonProperty(value="ruleSets")
    public List<UriReference> getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(List<UriReference> ruleSets) {
        this.ruleSets = ruleSets;
    }

    public Campaign skipPreviewDisabled(Boolean skipPreviewDisabled) {
        this.skipPreviewDisabled = skipPreviewDisabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not agents can skip previews without placing a call. Only applicable for preview campaigns.")
    @JsonProperty(value="skipPreviewDisabled")
    public Boolean getSkipPreviewDisabled() {
        return this.skipPreviewDisabled;
    }

    public void setSkipPreviewDisabled(Boolean skipPreviewDisabled) {
        this.skipPreviewDisabled = skipPreviewDisabled;
    }

    public Campaign previewTimeOutSeconds(Long previewTimeOutSeconds) {
        this.previewTimeOutSeconds = previewTimeOutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds before a call will be automatically placed on a preview. A value of 0 indicates no automatic placement of calls. Only applicable to preview campaigns.")
    @JsonProperty(value="previewTimeOutSeconds")
    public Long getPreviewTimeOutSeconds() {
        return this.previewTimeOutSeconds;
    }

    public void setPreviewTimeOutSeconds(Long previewTimeOutSeconds) {
        this.previewTimeOutSeconds = previewTimeOutSeconds;
    }

    public Campaign alwaysRunning(Boolean alwaysRunning) {
        this.alwaysRunning = alwaysRunning;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates (when true) that the campaign will remain on after contacts are depleted, allowing additional contacts to be appended/added to the contact list and processed by the still-running campaign. The campaign can still be turned off manually.")
    @JsonProperty(value="alwaysRunning")
    public Boolean getAlwaysRunning() {
        return this.alwaysRunning;
    }

    public void setAlwaysRunning(Boolean alwaysRunning) {
        this.alwaysRunning = alwaysRunning;
    }

    public Campaign contactSort(ContactSort contactSort) {
        this.contactSort = contactSort;
        return this;
    }

    @ApiModelProperty(example="null", value="The order in which to sort contacts for dialing, based on a column.")
    @JsonProperty(value="contactSort")
    public ContactSort getContactSort() {
        return this.contactSort;
    }

    public void setContactSort(ContactSort contactSort) {
        this.contactSort = contactSort;
    }

    public Campaign contactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
        return this;
    }

    @ApiModelProperty(example="null", value="The order in which to sort contacts for dialing, based on up to four columns.")
    @JsonProperty(value="contactSorts")
    public List<ContactSort> getContactSorts() {
        return this.contactSorts;
    }

    public void setContactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
    }

    public Campaign noAnswerTimeout(Integer noAnswerTimeout) {
        this.noAnswerTimeout = noAnswerTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to wait before dispositioning a call as 'no-answer'. Default 30 seconds. Only applicable to non-preview campaigns.")
    @JsonProperty(value="noAnswerTimeout")
    public Integer getNoAnswerTimeout() {
        return this.noAnswerTimeout;
    }

    public void setNoAnswerTimeout(Integer noAnswerTimeout) {
        this.noAnswerTimeout = noAnswerTimeout;
    }

    public Campaign callAnalysisLanguage(String callAnalysisLanguage) {
        this.callAnalysisLanguage = callAnalysisLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="The language the edge will use to analyze the call.")
    @JsonProperty(value="callAnalysisLanguage")
    public String getCallAnalysisLanguage() {
        return this.callAnalysisLanguage;
    }

    public void setCallAnalysisLanguage(String callAnalysisLanguage) {
        this.callAnalysisLanguage = callAnalysisLanguage;
    }

    public Campaign priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of this campaign relative to other campaigns that are running on the same queue. 5 is the highest priority, 1 the lowest.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Campaign contactListFilters(List<UriReference> contactListFilters) {
        this.contactListFilters = contactListFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter to apply to the contact list before dialing. Currently a campaign can only have one filter applied.")
    @JsonProperty(value="contactListFilters")
    public List<UriReference> getContactListFilters() {
        return this.contactListFilters;
    }

    public void setContactListFilters(List<UriReference> contactListFilters) {
        this.contactListFilters = contactListFilters;
    }

    public Campaign division(UriReference division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division this campaign belongs to.")
    @JsonProperty(value="division")
    public UriReference getDivision() {
        return this.division;
    }

    public void setDivision(UriReference division) {
        this.division = division;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign)o;
        return Objects.equals(this.id, campaign.id) && Objects.equals(this.name, campaign.name) && Objects.equals(this.dateCreated, campaign.dateCreated) && Objects.equals(this.dateModified, campaign.dateModified) && Objects.equals(this.version, campaign.version) && Objects.equals(this.contactList, campaign.contactList) && Objects.equals(this.queue, campaign.queue) && Objects.equals((Object)this.dialingMode, (Object)campaign.dialingMode) && Objects.equals(this.script, campaign.script) && Objects.equals(this.edgeGroup, campaign.edgeGroup) && Objects.equals(this.site, campaign.site) && Objects.equals((Object)this.campaignStatus, (Object)campaign.campaignStatus) && Objects.equals(this.phoneColumns, campaign.phoneColumns) && Objects.equals(this.abandonRate, campaign.abandonRate) && Objects.equals(this.dncLists, campaign.dncLists) && Objects.equals(this.callableTimeSet, campaign.callableTimeSet) && Objects.equals(this.callAnalysisResponseSet, campaign.callAnalysisResponseSet) && Objects.equals(this.errors, campaign.errors) && Objects.equals(this.callerName, campaign.callerName) && Objects.equals(this.callerAddress, campaign.callerAddress) && Objects.equals(this.outboundLineCount, campaign.outboundLineCount) && Objects.equals(this.ruleSets, campaign.ruleSets) && Objects.equals(this.skipPreviewDisabled, campaign.skipPreviewDisabled) && Objects.equals(this.previewTimeOutSeconds, campaign.previewTimeOutSeconds) && Objects.equals(this.alwaysRunning, campaign.alwaysRunning) && Objects.equals(this.contactSort, campaign.contactSort) && Objects.equals(this.contactSorts, campaign.contactSorts) && Objects.equals(this.noAnswerTimeout, campaign.noAnswerTimeout) && Objects.equals(this.callAnalysisLanguage, campaign.callAnalysisLanguage) && Objects.equals(this.priority, campaign.priority) && Objects.equals(this.contactListFilters, campaign.contactListFilters) && Objects.equals(this.division, campaign.division) && Objects.equals(this.selfUri, campaign.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.contactList, this.queue, this.dialingMode, this.script, this.edgeGroup, this.site, this.campaignStatus, this.phoneColumns, this.abandonRate, this.dncLists, this.callableTimeSet, this.callAnalysisResponseSet, this.errors, this.callerName, this.callerAddress, this.outboundLineCount, this.ruleSets, this.skipPreviewDisabled, this.previewTimeOutSeconds, this.alwaysRunning, this.contactSort, this.contactSorts, this.noAnswerTimeout, this.callAnalysisLanguage, this.priority, this.contactListFilters, this.division, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Campaign {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    contactList: ").append(this.toIndentedString(this.contactList)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    dialingMode: ").append(this.toIndentedString((Object)this.dialingMode)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    edgeGroup: ").append(this.toIndentedString(this.edgeGroup)).append("\n");
        sb.append("    site: ").append(this.toIndentedString(this.site)).append("\n");
        sb.append("    campaignStatus: ").append(this.toIndentedString((Object)this.campaignStatus)).append("\n");
        sb.append("    phoneColumns: ").append(this.toIndentedString(this.phoneColumns)).append("\n");
        sb.append("    abandonRate: ").append(this.toIndentedString(this.abandonRate)).append("\n");
        sb.append("    dncLists: ").append(this.toIndentedString(this.dncLists)).append("\n");
        sb.append("    callableTimeSet: ").append(this.toIndentedString(this.callableTimeSet)).append("\n");
        sb.append("    callAnalysisResponseSet: ").append(this.toIndentedString(this.callAnalysisResponseSet)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    callerName: ").append(this.toIndentedString(this.callerName)).append("\n");
        sb.append("    callerAddress: ").append(this.toIndentedString(this.callerAddress)).append("\n");
        sb.append("    outboundLineCount: ").append(this.toIndentedString(this.outboundLineCount)).append("\n");
        sb.append("    ruleSets: ").append(this.toIndentedString(this.ruleSets)).append("\n");
        sb.append("    skipPreviewDisabled: ").append(this.toIndentedString(this.skipPreviewDisabled)).append("\n");
        sb.append("    previewTimeOutSeconds: ").append(this.toIndentedString(this.previewTimeOutSeconds)).append("\n");
        sb.append("    alwaysRunning: ").append(this.toIndentedString(this.alwaysRunning)).append("\n");
        sb.append("    contactSort: ").append(this.toIndentedString(this.contactSort)).append("\n");
        sb.append("    contactSorts: ").append(this.toIndentedString(this.contactSorts)).append("\n");
        sb.append("    noAnswerTimeout: ").append(this.toIndentedString(this.noAnswerTimeout)).append("\n");
        sb.append("    callAnalysisLanguage: ").append(this.toIndentedString(this.callAnalysisLanguage)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    contactListFilters: ").append(this.toIndentedString(this.contactListFilters)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CampaignStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ON("on"),
        STOPPING("stopping"),
        OFF("off"),
        COMPLETE("complete"),
        INVALID("invalid");

        private String value;

        private CampaignStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CampaignStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CampaignStatusEnum value : CampaignStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CampaignStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DialingModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AGENTLESS("agentless"),
        PREVIEW("preview"),
        POWER("power"),
        PREDICTIVE("predictive"),
        PROGRESSIVE("progressive");

        private String value;

        private DialingModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DialingModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DialingModeEnum value : DialingModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DialingModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

