/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetScriptPageRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptPagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdPageRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdPagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsPublishedScriptIdVariablesRequest;
import com.mypurecloud.sdk.v2.api.request.GetScriptsRequest;
import com.mypurecloud.sdk.v2.model.Page;
import com.mypurecloud.sdk.v2.model.Script;
import com.mypurecloud.sdk.v2.model.ScriptEntityListing;
import java.io.IOException;
import java.util.List;

public class ScriptsApi {
    private final ApiClient pcapiClient;

    public ScriptsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScriptsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Script getScript(String scriptId) throws IOException, ApiException {
        return this.getScript(this.createGetScriptRequest(scriptId));
    }

    public ApiResponse<Script> getScriptWithHttpInfo(String scriptId) throws IOException {
        return this.getScript(this.createGetScriptRequest(scriptId).withHttpInfo());
    }

    private GetScriptRequest createGetScriptRequest(String scriptId) {
        return GetScriptRequest.builder().withScriptId(scriptId).build();
    }

    public Script getScript(GetScriptRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Script> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Script>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Script> getScript(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Script>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Page getScriptPage(String scriptId, String pageId) throws IOException, ApiException {
        return this.getScriptPage(this.createGetScriptPageRequest(scriptId, pageId));
    }

    public ApiResponse<Page> getScriptPageWithHttpInfo(String scriptId, String pageId) throws IOException {
        return this.getScriptPage(this.createGetScriptPageRequest(scriptId, pageId).withHttpInfo());
    }

    private GetScriptPageRequest createGetScriptPageRequest(String scriptId, String pageId) {
        return GetScriptPageRequest.builder().withScriptId(scriptId).withPageId(pageId).build();
    }

    public Page getScriptPage(GetScriptPageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Page> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Page>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Page> getScriptPage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Page>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<Page> getScriptPages(String scriptId) throws IOException, ApiException {
        return this.getScriptPages(this.createGetScriptPagesRequest(scriptId));
    }

    public ApiResponse<List<Page>> getScriptPagesWithHttpInfo(String scriptId) throws IOException {
        return this.getScriptPages(this.createGetScriptPagesRequest(scriptId).withHttpInfo());
    }

    private GetScriptPagesRequest createGetScriptPagesRequest(String scriptId) {
        return GetScriptPagesRequest.builder().withScriptId(scriptId).build();
    }

    public List<Page> getScriptPages(GetScriptPagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<Page>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<Page>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<Page>> getScriptPages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<Page>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ScriptEntityListing getScripts(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId, String sortBy, String sortOrder) throws IOException, ApiException {
        return this.getScripts(this.createGetScriptsRequest(pageSize, pageNumber, expand, name, feature, flowId, sortBy, sortOrder));
    }

    public ApiResponse<ScriptEntityListing> getScriptsWithHttpInfo(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId, String sortBy, String sortOrder) throws IOException {
        return this.getScripts(this.createGetScriptsRequest(pageSize, pageNumber, expand, name, feature, flowId, sortBy, sortOrder).withHttpInfo());
    }

    private GetScriptsRequest createGetScriptsRequest(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId, String sortBy, String sortOrder) {
        return GetScriptsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withExpand(expand).withName(name).withFeature(feature).withFlowId(flowId).withSortBy(sortBy).withSortOrder(sortOrder).build();
    }

    public ScriptEntityListing getScripts(GetScriptsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ScriptEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ScriptEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ScriptEntityListing> getScripts(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ScriptEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ScriptEntityListing getScriptsPublished(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId) throws IOException, ApiException {
        return this.getScriptsPublished(this.createGetScriptsPublishedRequest(pageSize, pageNumber, expand, name, feature, flowId));
    }

    public ApiResponse<ScriptEntityListing> getScriptsPublishedWithHttpInfo(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId) throws IOException {
        return this.getScriptsPublished(this.createGetScriptsPublishedRequest(pageSize, pageNumber, expand, name, feature, flowId).withHttpInfo());
    }

    private GetScriptsPublishedRequest createGetScriptsPublishedRequest(Integer pageSize, Integer pageNumber, String expand, String name, String feature, String flowId) {
        return GetScriptsPublishedRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withExpand(expand).withName(name).withFeature(feature).withFlowId(flowId).build();
    }

    public ScriptEntityListing getScriptsPublished(GetScriptsPublishedRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ScriptEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ScriptEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ScriptEntityListing> getScriptsPublished(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ScriptEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Script getScriptsPublishedScriptId(String scriptId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptId(this.createGetScriptsPublishedScriptIdRequest(scriptId));
    }

    public ApiResponse<Script> getScriptsPublishedScriptIdWithHttpInfo(String scriptId) throws IOException {
        return this.getScriptsPublishedScriptId(this.createGetScriptsPublishedScriptIdRequest(scriptId).withHttpInfo());
    }

    private GetScriptsPublishedScriptIdRequest createGetScriptsPublishedScriptIdRequest(String scriptId) {
        return GetScriptsPublishedScriptIdRequest.builder().withScriptId(scriptId).build();
    }

    public Script getScriptsPublishedScriptId(GetScriptsPublishedScriptIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Script> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Script>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Script> getScriptsPublishedScriptId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Script>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Page getScriptsPublishedScriptIdPage(String scriptId, String pageId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdPage(this.createGetScriptsPublishedScriptIdPageRequest(scriptId, pageId));
    }

    public ApiResponse<Page> getScriptsPublishedScriptIdPageWithHttpInfo(String scriptId, String pageId) throws IOException {
        return this.getScriptsPublishedScriptIdPage(this.createGetScriptsPublishedScriptIdPageRequest(scriptId, pageId).withHttpInfo());
    }

    private GetScriptsPublishedScriptIdPageRequest createGetScriptsPublishedScriptIdPageRequest(String scriptId, String pageId) {
        return GetScriptsPublishedScriptIdPageRequest.builder().withScriptId(scriptId).withPageId(pageId).build();
    }

    public Page getScriptsPublishedScriptIdPage(GetScriptsPublishedScriptIdPageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Page> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Page>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Page> getScriptsPublishedScriptIdPage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Page>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<Page> getScriptsPublishedScriptIdPages(String scriptId) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdPages(this.createGetScriptsPublishedScriptIdPagesRequest(scriptId));
    }

    public ApiResponse<List<Page>> getScriptsPublishedScriptIdPagesWithHttpInfo(String scriptId) throws IOException {
        return this.getScriptsPublishedScriptIdPages(this.createGetScriptsPublishedScriptIdPagesRequest(scriptId).withHttpInfo());
    }

    private GetScriptsPublishedScriptIdPagesRequest createGetScriptsPublishedScriptIdPagesRequest(String scriptId) {
        return GetScriptsPublishedScriptIdPagesRequest.builder().withScriptId(scriptId).build();
    }

    public List<Page> getScriptsPublishedScriptIdPages(GetScriptsPublishedScriptIdPagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<Page>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<Page>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<Page>> getScriptsPublishedScriptIdPages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<Page>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Object getScriptsPublishedScriptIdVariables(String scriptId, String input, String output, String type) throws IOException, ApiException {
        return this.getScriptsPublishedScriptIdVariables(this.createGetScriptsPublishedScriptIdVariablesRequest(scriptId, input, output, type));
    }

    public ApiResponse<Object> getScriptsPublishedScriptIdVariablesWithHttpInfo(String scriptId, String input, String output, String type) throws IOException {
        return this.getScriptsPublishedScriptIdVariables(this.createGetScriptsPublishedScriptIdVariablesRequest(scriptId, input, output, type).withHttpInfo());
    }

    private GetScriptsPublishedScriptIdVariablesRequest createGetScriptsPublishedScriptIdVariablesRequest(String scriptId, String input, String output, String type) {
        return GetScriptsPublishedScriptIdVariablesRequest.builder().withScriptId(scriptId).withInput(input).withOutput(output).withType(type).build();
    }

    public Object getScriptsPublishedScriptIdVariables(GetScriptsPublishedScriptIdVariablesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Object> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Object>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Object> getScriptsPublishedScriptIdVariables(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Object>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

