/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.GenericActionEvent;
import com.mypurecloud.sdk.v2.model.OutcomeAchievedEvent;
import com.mypurecloud.sdk.v2.model.SegmentAssignedEvent;
import com.mypurecloud.sdk.v2.model.Session;
import com.mypurecloud.sdk.v2.model.WebActionEvent;
import com.mypurecloud.sdk.v2.model.WebEvent;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Event
implements Serializable {
    private String id = null;
    private String correlationId = null;
    private String customerId = null;
    private String customerIdType = null;
    private Session session = null;
    private String eventType = null;
    private GenericActionEvent genericActionEvent = null;
    private OutcomeAchievedEvent outcomeAchievedEvent = null;
    private SegmentAssignedEvent segmentAssignedEvent = null;
    private WebActionEvent webActionEvent = null;
    private WebEvent webEvent = null;
    private Date createdDate = null;

    public Event id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="System-generated UUID for the event.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="UUID corresponding to triggering action that caused this event (e.g. HTTP POST, SIP invite, another event).")
    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    public Event customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Primary identifier of the customer in the source of the events.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Event customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of primary identifier (e.g. cookie, email, phone, salesforce).")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public Event session(Session session) {
        this.session = session;
        return this;
    }

    @ApiModelProperty(example="null", value="The session that the event belongs to.")
    @JsonProperty(value="session")
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Event eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name representing the type of event.")
    @JsonProperty(value="eventType")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Event genericActionEvent(GenericActionEvent genericActionEvent) {
        this.genericActionEvent = genericActionEvent;
        return this;
    }

    @ApiModelProperty(example="null", value="Event triggered by generic actions.")
    @JsonProperty(value="genericActionEvent")
    public GenericActionEvent getGenericActionEvent() {
        return this.genericActionEvent;
    }

    public void setGenericActionEvent(GenericActionEvent genericActionEvent) {
        this.genericActionEvent = genericActionEvent;
    }

    public Event outcomeAchievedEvent(OutcomeAchievedEvent outcomeAchievedEvent) {
        this.outcomeAchievedEvent = outcomeAchievedEvent;
        return this;
    }

    @ApiModelProperty(example="null", value="Event where a customer has achieved a specific outcome or goal.")
    @JsonProperty(value="outcomeAchievedEvent")
    public OutcomeAchievedEvent getOutcomeAchievedEvent() {
        return this.outcomeAchievedEvent;
    }

    public void setOutcomeAchievedEvent(OutcomeAchievedEvent outcomeAchievedEvent) {
        this.outcomeAchievedEvent = outcomeAchievedEvent;
    }

    public Event segmentAssignedEvent(SegmentAssignedEvent segmentAssignedEvent) {
        this.segmentAssignedEvent = segmentAssignedEvent;
        return this;
    }

    @ApiModelProperty(example="null", value="Event where a customer has been assigned or tagged with a specific segment.")
    @JsonProperty(value="segmentAssignedEvent")
    public SegmentAssignedEvent getSegmentAssignedEvent() {
        return this.segmentAssignedEvent;
    }

    public void setSegmentAssignedEvent(SegmentAssignedEvent segmentAssignedEvent) {
        this.segmentAssignedEvent = segmentAssignedEvent;
    }

    public Event webActionEvent(WebActionEvent webActionEvent) {
        this.webActionEvent = webActionEvent;
        return this;
    }

    @ApiModelProperty(example="null", value="Event triggered by web actions.")
    @JsonProperty(value="webActionEvent")
    public WebActionEvent getWebActionEvent() {
        return this.webActionEvent;
    }

    public void setWebActionEvent(WebActionEvent webActionEvent) {
        this.webActionEvent = webActionEvent;
    }

    public Event webEvent(WebEvent webEvent) {
        this.webEvent = webEvent;
        return this;
    }

    @ApiModelProperty(example="null", value="Event that tracks user interactions with content in a browser such as pageviews, downloads, mobile ad clicks, etc.")
    @JsonProperty(value="webEvent")
    public WebEvent getWebEvent() {
        return this.webEvent;
    }

    public void setWebEvent(WebEvent webEvent) {
        this.webEvent = webEvent;
    }

    public Event createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the event actually took place. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.id, event.id) && Objects.equals(this.correlationId, event.correlationId) && Objects.equals(this.customerId, event.customerId) && Objects.equals(this.customerIdType, event.customerIdType) && Objects.equals(this.session, event.session) && Objects.equals(this.eventType, event.eventType) && Objects.equals(this.genericActionEvent, event.genericActionEvent) && Objects.equals(this.outcomeAchievedEvent, event.outcomeAchievedEvent) && Objects.equals(this.segmentAssignedEvent, event.segmentAssignedEvent) && Objects.equals(this.webActionEvent, event.webActionEvent) && Objects.equals(this.webEvent, event.webEvent) && Objects.equals(this.createdDate, event.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.correlationId, this.customerId, this.customerIdType, this.session, this.eventType, this.genericActionEvent, this.outcomeAchievedEvent, this.segmentAssignedEvent, this.webActionEvent, this.webEvent, this.createdDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    genericActionEvent: ").append(this.toIndentedString(this.genericActionEvent)).append("\n");
        sb.append("    outcomeAchievedEvent: ").append(this.toIndentedString(this.outcomeAchievedEvent)).append("\n");
        sb.append("    segmentAssignedEvent: ").append(this.toIndentedString(this.segmentAssignedEvent)).append("\n");
        sb.append("    webActionEvent: ").append(this.toIndentedString(this.webActionEvent)).append("\n");
        sb.append("    webEvent: ").append(this.toIndentedString(this.webEvent)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

