/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetJourneySessionEventsRequest;
import com.mypurecloud.sdk.v2.model.EventListing;
import java.io.IOException;

public class JourneyApi {
    private final ApiClient pcapiClient;

    public JourneyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JourneyApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public EventListing getJourneySessionEvents(String sessionId, String before, String after, String limit) throws IOException, ApiException {
        return this.getJourneySessionEvents(this.createGetJourneySessionEventsRequest(sessionId, before, after, limit));
    }

    public ApiResponse<EventListing> getJourneySessionEventsWithHttpInfo(String sessionId, String before, String after, String limit) throws IOException {
        return this.getJourneySessionEvents(this.createGetJourneySessionEventsRequest(sessionId, before, after, limit).withHttpInfo());
    }

    private GetJourneySessionEventsRequest createGetJourneySessionEventsRequest(String sessionId, String before, String after, String limit) {
        return GetJourneySessionEventsRequest.builder().withSessionId(sessionId).withBefore(before).withAfter(after).withLimit(limit).build();
    }

    public EventListing getJourneySessionEvents(GetJourneySessionEventsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EventListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EventListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EventListing> getJourneySessionEvents(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EventListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

