/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.ning;

import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperties;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperty;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProvider;
import com.mypurecloud.sdk.v2.connector.ning.AsyncHttpClientConnector;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.proxy.ProxyServerSelector;
import org.asynchttpclient.util.ProxyUtils;

public class AsyncHttpClientConnectorProvider
implements ApiClientConnectorProvider {
    @Override
    public ApiClientConnector create(ApiClientConnectorProperties properties) {
        Proxy proxy;
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        Integer connectionTimeout = properties.getProperty(ApiClientConnectorProperty.CONNECTION_TIMEOUT, Integer.class, null);
        if (connectionTimeout != null && connectionTimeout > 0) {
            builder.setConnectTimeout(connectionTimeout.intValue());
            builder.setReadTimeout(connectionTimeout.intValue());
            builder.setRequestTimeout(connectionTimeout.intValue());
        }
        if ((proxy = (Proxy)properties.getProperty(ApiClientConnectorProperty.PROXY, Proxy.class, null)) != null) {
            ProxySelector proxySelector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    return Collections.singletonList(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            };
            ProxyServerSelector proxyServerSelector = ProxyUtils.createProxyServerSelector((ProxySelector)proxySelector);
            builder.setProxyServerSelector(proxyServerSelector);
            builder.setUseProxySelector(true);
        }
        DefaultAsyncHttpClientConfig config = builder.build();
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)config);
        return new AsyncHttpClientConnector((AsyncHttpClient)client);
    }
}

