/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.apache;

import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorRequest;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import com.mypurecloud.sdk.v2.connector.apache.ApacheHttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheHttpClientConnector
implements ApiClientConnector {
    private final CloseableHttpClient client;
    private final ExecutorService executorService;

    public ApacheHttpClientConnector(CloseableHttpClient client, ExecutorService executorService) {
        this.client = client;
        this.executorService = executorService;
    }

    @Override
    public ApiClientConnectorResponse invoke(ApiClientConnectorRequest request) throws IOException {
        Object httpUriRequest;
        Object req;
        String method = request.getMethod();
        String url = request.getUrl();
        String body = request.readBody();
        if ("GET".equals(method)) {
            req = new HttpGet(url);
            httpUriRequest = req;
        } else if ("HEAD".equals(method)) {
            req = new HttpHead(url);
            httpUriRequest = req;
        } else if ("POST".equals(method)) {
            req = new HttpPost(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else if ("PUT".equals(method)) {
            req = new HttpPut(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else if ("DELETE".equals(method)) {
            req = new HttpDelete(url);
            httpUriRequest = req;
        } else if ("PATCH".equals(method)) {
            req = new HttpPatch(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else {
            throw new IllegalStateException("Unknown method type " + method);
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpUriRequest);
        return new ApacheHttpResponse(response);
    }

    @Override
    public Future<ApiClientConnectorResponse> invokeAsync(final ApiClientConnectorRequest request, final AsyncApiCallback<ApiClientConnectorResponse> callback) {
        final SettableFuture future = SettableFuture.create();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ApiClientConnectorResponse response = ApacheHttpClientConnector.this.invoke(request);
                    callback.onCompleted(response);
                    future.set((Object)response);
                }
                catch (Throwable exception) {
                    callback.onFailed(exception);
                    future.setException(exception);
                }
            }
        };
        try {
            if (this.executorService != null) {
                this.executorService.submit(task);
            } else {
                task.run();
            }
        }
        catch (Throwable exception) {
            callback.onFailed(exception);
            future.setException(exception);
        }
        return future;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

