/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteUserRolesRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationPermissionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationProductsRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRoleComparedefaultRightRoleIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRolesRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserRolesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRoleComparedefaultRightRoleIdRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRolesDefaultRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRolesRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleUsersAddRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleUsersRemoveRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRolesDefaultRequest;
import com.mypurecloud.sdk.v2.api.request.PutUserRolesRequest;
import com.mypurecloud.sdk.v2.model.DomainOrgRoleDifference;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRole;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRoleCreate;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRoleUpdate;
import com.mypurecloud.sdk.v2.model.OrganizationProductEntityListing;
import com.mypurecloud.sdk.v2.model.OrganizationRoleEntityListing;
import com.mypurecloud.sdk.v2.model.PermissionCollectionEntityListing;
import com.mypurecloud.sdk.v2.model.UserAuthorization;
import java.io.IOException;
import java.util.List;

public class AuthorizationApi {
    private final ApiClient pcapiClient;

    public AuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAuthorizationRole(String roleId) throws IOException, ApiException {
        this.deleteAuthorizationRole(this.createDeleteAuthorizationRoleRequest(roleId));
    }

    public ApiResponse<Void> deleteAuthorizationRoleWithHttpInfo(String roleId) throws IOException {
        return this.deleteAuthorizationRole(this.createDeleteAuthorizationRoleRequest(roleId).withHttpInfo());
    }

    private DeleteAuthorizationRoleRequest createDeleteAuthorizationRoleRequest(String roleId) {
        return DeleteAuthorizationRoleRequest.builder().withRoleId(roleId).build();
    }

    public void deleteAuthorizationRole(DeleteAuthorizationRoleRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAuthorizationRole(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteUserRoles(String userId) throws IOException, ApiException {
        this.deleteUserRoles(this.createDeleteUserRolesRequest(userId));
    }

    public ApiResponse<Void> deleteUserRolesWithHttpInfo(String userId) throws IOException {
        return this.deleteUserRoles(this.createDeleteUserRolesRequest(userId).withHttpInfo());
    }

    private DeleteUserRolesRequest createDeleteUserRolesRequest(String userId) {
        return DeleteUserRolesRequest.builder().withUserId(userId).build();
    }

    public void deleteUserRoles(DeleteUserRolesRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteUserRoles(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PermissionCollectionEntityListing getAuthorizationPermissions(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getAuthorizationPermissions(this.createGetAuthorizationPermissionsRequest(pageSize, pageNumber));
    }

    public ApiResponse<PermissionCollectionEntityListing> getAuthorizationPermissionsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getAuthorizationPermissions(this.createGetAuthorizationPermissionsRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetAuthorizationPermissionsRequest createGetAuthorizationPermissionsRequest(Integer pageSize, Integer pageNumber) {
        return GetAuthorizationPermissionsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public PermissionCollectionEntityListing getAuthorizationPermissions(GetAuthorizationPermissionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PermissionCollectionEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PermissionCollectionEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PermissionCollectionEntityListing> getAuthorizationPermissions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PermissionCollectionEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrganizationProductEntityListing getAuthorizationProducts() throws IOException, ApiException {
        return this.getAuthorizationProducts(this.createGetAuthorizationProductsRequest());
    }

    public ApiResponse<OrganizationProductEntityListing> getAuthorizationProductsWithHttpInfo() throws IOException {
        return this.getAuthorizationProducts(this.createGetAuthorizationProductsRequest().withHttpInfo());
    }

    private GetAuthorizationProductsRequest createGetAuthorizationProductsRequest() {
        return GetAuthorizationProductsRequest.builder().build();
    }

    public OrganizationProductEntityListing getAuthorizationProducts(GetAuthorizationProductsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrganizationProductEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrganizationProductEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrganizationProductEntityListing> getAuthorizationProducts(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrganizationProductEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrganizationRole getAuthorizationRole(String roleId) throws IOException, ApiException {
        return this.getAuthorizationRole(this.createGetAuthorizationRoleRequest(roleId));
    }

    public ApiResponse<DomainOrganizationRole> getAuthorizationRoleWithHttpInfo(String roleId) throws IOException {
        return this.getAuthorizationRole(this.createGetAuthorizationRoleRequest(roleId).withHttpInfo());
    }

    private GetAuthorizationRoleRequest createGetAuthorizationRoleRequest(String roleId) {
        return GetAuthorizationRoleRequest.builder().withRoleId(roleId).build();
    }

    public DomainOrganizationRole getAuthorizationRole(GetAuthorizationRoleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrganizationRole> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrganizationRole> getAuthorizationRole(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrganizationRole>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrgRoleDifference getAuthorizationRoleComparedefaultRightRoleId(String leftRoleId, String rightRoleId) throws IOException, ApiException {
        return this.getAuthorizationRoleComparedefaultRightRoleId(this.createGetAuthorizationRoleComparedefaultRightRoleIdRequest(leftRoleId, rightRoleId));
    }

    public ApiResponse<DomainOrgRoleDifference> getAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(String leftRoleId, String rightRoleId) throws IOException {
        return this.getAuthorizationRoleComparedefaultRightRoleId(this.createGetAuthorizationRoleComparedefaultRightRoleIdRequest(leftRoleId, rightRoleId).withHttpInfo());
    }

    private GetAuthorizationRoleComparedefaultRightRoleIdRequest createGetAuthorizationRoleComparedefaultRightRoleIdRequest(String leftRoleId, String rightRoleId) {
        return GetAuthorizationRoleComparedefaultRightRoleIdRequest.builder().withLeftRoleId(leftRoleId).withRightRoleId(rightRoleId).build();
    }

    public DomainOrgRoleDifference getAuthorizationRoleComparedefaultRightRoleId(GetAuthorizationRoleComparedefaultRightRoleIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrgRoleDifference> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrgRoleDifference>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrgRoleDifference> getAuthorizationRoleComparedefaultRightRoleId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrgRoleDifference>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrganizationRoleEntityListing getAuthorizationRoles(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, List<Object> permission, Boolean userCount) throws IOException, ApiException {
        return this.getAuthorizationRoles(this.createGetAuthorizationRolesRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, permission, userCount));
    }

    public ApiResponse<OrganizationRoleEntityListing> getAuthorizationRolesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, List<Object> permission, Boolean userCount) throws IOException {
        return this.getAuthorizationRoles(this.createGetAuthorizationRolesRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, permission, userCount).withHttpInfo());
    }

    private GetAuthorizationRolesRequest createGetAuthorizationRolesRequest(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, List<Object> permission, Boolean userCount) {
        return GetAuthorizationRolesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).withPermission(permission).withUserCount(userCount).build();
    }

    public OrganizationRoleEntityListing getAuthorizationRoles(GetAuthorizationRolesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrganizationRoleEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrganizationRoleEntityListing> getAuthorizationRoles(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrganizationRoleEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserAuthorization getUserRoles(String userId) throws IOException, ApiException {
        return this.getUserRoles(this.createGetUserRolesRequest(userId));
    }

    public ApiResponse<UserAuthorization> getUserRolesWithHttpInfo(String userId) throws IOException {
        return this.getUserRoles(this.createGetUserRolesRequest(userId).withHttpInfo());
    }

    private GetUserRolesRequest createGetUserRolesRequest(String userId) {
        return GetUserRolesRequest.builder().withUserId(userId).build();
    }

    public UserAuthorization getUserRoles(GetUserRolesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserAuthorization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserAuthorization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserAuthorization> getUserRoles(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserAuthorization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrganizationRole patchAuthorizationRole(String roleId, DomainOrganizationRole body) throws IOException, ApiException {
        return this.patchAuthorizationRole(this.createPatchAuthorizationRoleRequest(roleId, body));
    }

    public ApiResponse<DomainOrganizationRole> patchAuthorizationRoleWithHttpInfo(String roleId, DomainOrganizationRole body) throws IOException {
        return this.patchAuthorizationRole(this.createPatchAuthorizationRoleRequest(roleId, body).withHttpInfo());
    }

    private PatchAuthorizationRoleRequest createPatchAuthorizationRoleRequest(String roleId, DomainOrganizationRole body) {
        return PatchAuthorizationRoleRequest.builder().withRoleId(roleId).withBody(body).build();
    }

    public DomainOrganizationRole patchAuthorizationRole(PatchAuthorizationRoleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrganizationRole> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrganizationRole> patchAuthorizationRole(ApiRequest<DomainOrganizationRole> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrganizationRole>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrgRoleDifference postAuthorizationRoleComparedefaultRightRoleId(String leftRoleId, String rightRoleId, DomainOrganizationRole body) throws IOException, ApiException {
        return this.postAuthorizationRoleComparedefaultRightRoleId(this.createPostAuthorizationRoleComparedefaultRightRoleIdRequest(leftRoleId, rightRoleId, body));
    }

    public ApiResponse<DomainOrgRoleDifference> postAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(String leftRoleId, String rightRoleId, DomainOrganizationRole body) throws IOException {
        return this.postAuthorizationRoleComparedefaultRightRoleId(this.createPostAuthorizationRoleComparedefaultRightRoleIdRequest(leftRoleId, rightRoleId, body).withHttpInfo());
    }

    private PostAuthorizationRoleComparedefaultRightRoleIdRequest createPostAuthorizationRoleComparedefaultRightRoleIdRequest(String leftRoleId, String rightRoleId, DomainOrganizationRole body) {
        return PostAuthorizationRoleComparedefaultRightRoleIdRequest.builder().withLeftRoleId(leftRoleId).withRightRoleId(rightRoleId).withBody(body).build();
    }

    public DomainOrgRoleDifference postAuthorizationRoleComparedefaultRightRoleId(PostAuthorizationRoleComparedefaultRightRoleIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrgRoleDifference> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrgRoleDifference>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrgRoleDifference> postAuthorizationRoleComparedefaultRightRoleId(ApiRequest<DomainOrganizationRole> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrgRoleDifference>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrganizationRole postAuthorizationRoles(DomainOrganizationRoleCreate body) throws IOException, ApiException {
        return this.postAuthorizationRoles(this.createPostAuthorizationRolesRequest(body));
    }

    public ApiResponse<DomainOrganizationRole> postAuthorizationRolesWithHttpInfo(DomainOrganizationRoleCreate body) throws IOException {
        return this.postAuthorizationRoles(this.createPostAuthorizationRolesRequest(body).withHttpInfo());
    }

    private PostAuthorizationRolesRequest createPostAuthorizationRolesRequest(DomainOrganizationRoleCreate body) {
        return PostAuthorizationRolesRequest.builder().withBody(body).build();
    }

    public DomainOrganizationRole postAuthorizationRoles(PostAuthorizationRolesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrganizationRole> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrganizationRole> postAuthorizationRoles(ApiRequest<DomainOrganizationRoleCreate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrganizationRole>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrganizationRoleEntityListing postAuthorizationRolesDefault(Boolean force) throws IOException, ApiException {
        return this.postAuthorizationRolesDefault(this.createPostAuthorizationRolesDefaultRequest(force));
    }

    public ApiResponse<OrganizationRoleEntityListing> postAuthorizationRolesDefaultWithHttpInfo(Boolean force) throws IOException {
        return this.postAuthorizationRolesDefault(this.createPostAuthorizationRolesDefaultRequest(force).withHttpInfo());
    }

    private PostAuthorizationRolesDefaultRequest createPostAuthorizationRolesDefaultRequest(Boolean force) {
        return PostAuthorizationRolesDefaultRequest.builder().withForce(force).build();
    }

    public OrganizationRoleEntityListing postAuthorizationRolesDefault(PostAuthorizationRolesDefaultRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrganizationRoleEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrganizationRoleEntityListing> postAuthorizationRolesDefault(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrganizationRoleEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DomainOrganizationRole putAuthorizationRole(String roleId, DomainOrganizationRoleUpdate body) throws IOException, ApiException {
        return this.putAuthorizationRole(this.createPutAuthorizationRoleRequest(roleId, body));
    }

    public ApiResponse<DomainOrganizationRole> putAuthorizationRoleWithHttpInfo(String roleId, DomainOrganizationRoleUpdate body) throws IOException {
        return this.putAuthorizationRole(this.createPutAuthorizationRoleRequest(roleId, body).withHttpInfo());
    }

    private PutAuthorizationRoleRequest createPutAuthorizationRoleRequest(String roleId, DomainOrganizationRoleUpdate body) {
        return PutAuthorizationRoleRequest.builder().withRoleId(roleId).withBody(body).build();
    }

    public DomainOrganizationRole putAuthorizationRole(PutAuthorizationRoleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DomainOrganizationRole> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DomainOrganizationRole> putAuthorizationRole(ApiRequest<DomainOrganizationRoleUpdate> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DomainOrganizationRole>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<String> putAuthorizationRoleUsersAdd(String roleId, List<String> body) throws IOException, ApiException {
        return this.putAuthorizationRoleUsersAdd(this.createPutAuthorizationRoleUsersAddRequest(roleId, body));
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersAddWithHttpInfo(String roleId, List<String> body) throws IOException {
        return this.putAuthorizationRoleUsersAdd(this.createPutAuthorizationRoleUsersAddRequest(roleId, body).withHttpInfo());
    }

    private PutAuthorizationRoleUsersAddRequest createPutAuthorizationRoleUsersAddRequest(String roleId, List<String> body) {
        return PutAuthorizationRoleUsersAddRequest.builder().withRoleId(roleId).withBody(body).build();
    }

    public List<String> putAuthorizationRoleUsersAdd(PutAuthorizationRoleUsersAddRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<String>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<String>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersAdd(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<String>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<String> putAuthorizationRoleUsersRemove(String roleId, List<String> body) throws IOException, ApiException {
        return this.putAuthorizationRoleUsersRemove(this.createPutAuthorizationRoleUsersRemoveRequest(roleId, body));
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersRemoveWithHttpInfo(String roleId, List<String> body) throws IOException {
        return this.putAuthorizationRoleUsersRemove(this.createPutAuthorizationRoleUsersRemoveRequest(roleId, body).withHttpInfo());
    }

    private PutAuthorizationRoleUsersRemoveRequest createPutAuthorizationRoleUsersRemoveRequest(String roleId, List<String> body) {
        return PutAuthorizationRoleUsersRemoveRequest.builder().withRoleId(roleId).withBody(body).build();
    }

    public List<String> putAuthorizationRoleUsersRemove(PutAuthorizationRoleUsersRemoveRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<String>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<String>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersRemove(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<String>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OrganizationRoleEntityListing putAuthorizationRolesDefault(List<DomainOrganizationRole> body) throws IOException, ApiException {
        return this.putAuthorizationRolesDefault(this.createPutAuthorizationRolesDefaultRequest(body));
    }

    public ApiResponse<OrganizationRoleEntityListing> putAuthorizationRolesDefaultWithHttpInfo(List<DomainOrganizationRole> body) throws IOException {
        return this.putAuthorizationRolesDefault(this.createPutAuthorizationRolesDefaultRequest(body).withHttpInfo());
    }

    private PutAuthorizationRolesDefaultRequest createPutAuthorizationRolesDefaultRequest(List<DomainOrganizationRole> body) {
        return PutAuthorizationRolesDefaultRequest.builder().withBody(body).build();
    }

    public OrganizationRoleEntityListing putAuthorizationRolesDefault(PutAuthorizationRolesDefaultRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OrganizationRoleEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OrganizationRoleEntityListing> putAuthorizationRolesDefault(ApiRequest<List<DomainOrganizationRole>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OrganizationRoleEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserAuthorization putUserRoles(String userId, List<String> body) throws IOException, ApiException {
        return this.putUserRoles(this.createPutUserRolesRequest(userId, body));
    }

    public ApiResponse<UserAuthorization> putUserRolesWithHttpInfo(String userId, List<String> body) throws IOException {
        return this.putUserRoles(this.createPutUserRolesRequest(userId, body).withHttpInfo());
    }

    private PutUserRolesRequest createPutUserRolesRequest(String userId, List<String> body) {
        return PutUserRolesRequest.builder().withUserId(userId).withBody(body).build();
    }

    public UserAuthorization putUserRoles(PutUserRolesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserAuthorization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserAuthorization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserAuthorization> putUserRoles(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserAuthorization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

