/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserScheduleActivity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Single shift in a user's schedule")
public class UserScheduleShift
implements Serializable {
    private Date startDate = null;
    private Integer lengthInMinutes = null;
    private List<UserScheduleActivity> activities = new ArrayList<UserScheduleActivity>();

    public UserScheduleShift startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Start time in UTC for this shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public UserScheduleShift lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Length of this shift in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public UserScheduleShift activities(List<UserScheduleActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="List of activities in this shift")
    @JsonProperty(value="activities")
    public List<UserScheduleActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<UserScheduleActivity> activities) {
        this.activities = activities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserScheduleShift userScheduleShift = (UserScheduleShift)o;
        return Objects.equals(this.startDate, userScheduleShift.startDate) && Objects.equals(this.lengthInMinutes, userScheduleShift.lengthInMinutes) && Objects.equals(this.activities, userScheduleShift.activities);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.lengthInMinutes, this.activities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserScheduleShift {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

