/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsCallParticipantsRequest {
    private String conversationId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsCallParticipantsRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PostConversationsCallParticipantsRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsCallParticipantsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsCallParticipantsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsCallParticipantsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/calls/{conversationId}/participants").withPathParameter("conversationId", this.conversationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, Conversation body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PostConversationsCallParticipantsRequest request = new PostConversationsCallParticipantsRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, Conversation body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsCallParticipantsRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsCallParticipantsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsCallParticipantsRequest.");
            }
            return this.request;
        }
    }
}

