/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.FaxDocument;
import java.util.HashMap;
import java.util.Map;

public class PutFaxDocumentRequest {
    private String documentId;
    private FaxDocument body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PutFaxDocumentRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public FaxDocument getBody() {
        return this.body;
    }

    public void setBody(FaxDocument body) {
        this.body = body;
    }

    public PutFaxDocumentRequest withBody(FaxDocument body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutFaxDocumentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<FaxDocument> withHttpInfo() {
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PutFaxDocumentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutFaxDocumentRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/fax/documents/{documentId}").withPathParameter("documentId", this.documentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String documentId, FaxDocument body) {
        return new Builder().withRequiredParams(documentId, body);
    }

    public static class Builder {
        private final PutFaxDocumentRequest request = new PutFaxDocumentRequest();

        private Builder() {
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(FaxDocument body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String documentId, FaxDocument body) {
            this.request.setDocumentId(documentId);
            this.request.setBody(body);
            return this;
        }

        public PutFaxDocumentRequest build() {
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PutFaxDocumentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutFaxDocumentRequest.");
            }
            return this.request;
        }
    }
}

