/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Information containing details of a schedule run")
public class SchedulingRunResponse
implements Serializable {
    private String runId = null;
    private StateEnum state = null;
    private Double percentComplete = null;
    private String targetWeek = null;
    private String scheduleId = null;
    private String scheduleDescription = null;
    private Date schedulingStartTime = null;
    private UserReference schedulingStartedBy = null;
    private UserReference schedulingCanceledBy = null;
    private Date schedulingCompletedTime = null;

    public SchedulingRunResponse runId(String runId) {
        this.runId = runId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the schedule run")
    @JsonProperty(value="runId")
    public String getRunId() {
        return this.runId;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public SchedulingRunResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the schedule run")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SchedulingRunResponse percentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    @ApiModelProperty(example="null", value="Completion percentage of the schedule run")
    @JsonProperty(value="percentComplete")
    public Double getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
    }

    public SchedulingRunResponse targetWeek(String targetWeek) {
        this.targetWeek = targetWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date of the week for which the scheduling is done in yyyy-MM-dd format")
    @JsonProperty(value="targetWeek")
    public String getTargetWeek() {
        return this.targetWeek;
    }

    public void setTargetWeek(String targetWeek) {
        this.targetWeek = targetWeek;
    }

    public SchedulingRunResponse scheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the schedule")
    @JsonProperty(value="scheduleId")
    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public SchedulingRunResponse scheduleDescription(String scheduleDescription) {
        this.scheduleDescription = scheduleDescription;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the schedule run")
    @JsonProperty(value="scheduleDescription")
    public String getScheduleDescription() {
        return this.scheduleDescription;
    }

    public void setScheduleDescription(String scheduleDescription) {
        this.scheduleDescription = scheduleDescription;
    }

    public SchedulingRunResponse schedulingStartTime(Date schedulingStartTime) {
        this.schedulingStartTime = schedulingStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Start time of the schedule run. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="schedulingStartTime")
    public Date getSchedulingStartTime() {
        return this.schedulingStartTime;
    }

    public void setSchedulingStartTime(Date schedulingStartTime) {
        this.schedulingStartTime = schedulingStartTime;
    }

    public SchedulingRunResponse schedulingStartedBy(UserReference schedulingStartedBy) {
        this.schedulingStartedBy = schedulingStartedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that started the schedule run")
    @JsonProperty(value="schedulingStartedBy")
    public UserReference getSchedulingStartedBy() {
        return this.schedulingStartedBy;
    }

    public void setSchedulingStartedBy(UserReference schedulingStartedBy) {
        this.schedulingStartedBy = schedulingStartedBy;
    }

    public SchedulingRunResponse schedulingCanceledBy(UserReference schedulingCanceledBy) {
        this.schedulingCanceledBy = schedulingCanceledBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that canceled the schedule run")
    @JsonProperty(value="schedulingCanceledBy")
    public UserReference getSchedulingCanceledBy() {
        return this.schedulingCanceledBy;
    }

    public void setSchedulingCanceledBy(UserReference schedulingCanceledBy) {
        this.schedulingCanceledBy = schedulingCanceledBy;
    }

    public SchedulingRunResponse schedulingCompletedTime(Date schedulingCompletedTime) {
        this.schedulingCompletedTime = schedulingCompletedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time at which the scheduling run was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="schedulingCompletedTime")
    public Date getSchedulingCompletedTime() {
        return this.schedulingCompletedTime;
    }

    public void setSchedulingCompletedTime(Date schedulingCompletedTime) {
        this.schedulingCompletedTime = schedulingCompletedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunResponse schedulingRunResponse = (SchedulingRunResponse)o;
        return Objects.equals(this.runId, schedulingRunResponse.runId) && Objects.equals((Object)this.state, (Object)schedulingRunResponse.state) && Objects.equals(this.percentComplete, schedulingRunResponse.percentComplete) && Objects.equals(this.targetWeek, schedulingRunResponse.targetWeek) && Objects.equals(this.scheduleId, schedulingRunResponse.scheduleId) && Objects.equals(this.scheduleDescription, schedulingRunResponse.scheduleDescription) && Objects.equals(this.schedulingStartTime, schedulingRunResponse.schedulingStartTime) && Objects.equals(this.schedulingStartedBy, schedulingRunResponse.schedulingStartedBy) && Objects.equals(this.schedulingCanceledBy, schedulingRunResponse.schedulingCanceledBy) && Objects.equals(this.schedulingCompletedTime, schedulingRunResponse.schedulingCompletedTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.runId, this.state, this.percentComplete, this.targetWeek, this.scheduleId, this.scheduleDescription, this.schedulingStartTime, this.schedulingStartedBy, this.schedulingCanceledBy, this.schedulingCompletedTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchedulingRunResponse {\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("    targetWeek: ").append(this.toIndentedString(this.targetWeek)).append("\n");
        sb.append("    scheduleId: ").append(this.toIndentedString(this.scheduleId)).append("\n");
        sb.append("    scheduleDescription: ").append(this.toIndentedString(this.scheduleDescription)).append("\n");
        sb.append("    schedulingStartTime: ").append(this.toIndentedString(this.schedulingStartTime)).append("\n");
        sb.append("    schedulingStartedBy: ").append(this.toIndentedString(this.schedulingStartedBy)).append("\n");
        sb.append("    schedulingCanceledBy: ").append(this.toIndentedString(this.schedulingCanceledBy)).append("\n");
        sb.append("    schedulingCompletedTime: ").append(this.toIndentedString(this.schedulingCompletedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        QUEUED("Queued"),
        SCHEDULING("Scheduling"),
        CANCELED("Canceled"),
        FAILED("Failed"),
        COMPLETE("Complete");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

