/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationRecordingRequest {
    private String conversationId;
    private String recordingId;
    private String formatId;
    private Boolean download;
    private String fileName;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationRecordingRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public void setRecordingId(String recordingId) {
        this.recordingId = recordingId;
    }

    public GetConversationRecordingRequest withRecordingId(String recordingId) {
        this.setRecordingId(recordingId);
        return this;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public GetConversationRecordingRequest withFormatId(String formatId) {
        this.setFormatId(formatId);
        return this;
    }

    public Boolean getDownload() {
        return this.download;
    }

    public void setDownload(Boolean download) {
        this.download = download;
    }

    public GetConversationRecordingRequest withDownload(Boolean download) {
        this.setDownload(download);
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public GetConversationRecordingRequest withFileName(String fileName) {
        this.setFileName(fileName);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationRecordingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingRequest.");
        }
        if (this.recordingId == null) {
            throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/recordings/{recordingId}").withPathParameter("conversationId", this.conversationId).withPathParameter("recordingId", this.recordingId).withQueryParameters("formatId", "", this.formatId).withQueryParameters("download", "", this.download).withQueryParameters("fileName", "", this.fileName).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String recordingId) {
        return new Builder().withRequiredParams(conversationId, recordingId);
    }

    public static class Builder {
        private final GetConversationRecordingRequest request = new GetConversationRecordingRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRecordingId(String recordingId) {
            this.request.setRecordingId(recordingId);
            return this;
        }

        public Builder withFormatId(String formatId) {
            this.request.setFormatId(formatId);
            return this;
        }

        public Builder withDownload(Boolean download) {
            this.request.setDownload(download);
            return this;
        }

        public Builder withFileName(String fileName) {
            this.request.setFileName(fileName);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String recordingId) {
            this.request.setConversationId(conversationId);
            this.request.setRecordingId(recordingId);
            return this;
        }

        public GetConversationRecordingRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingRequest.");
            }
            if (this.request.recordingId == null) {
                throw new IllegalStateException("Missing the required parameter 'recordingId' when building request for GetConversationRecordingRequest.");
            }
            return this.request;
        }
    }
}

