/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostArchitectPromptHistoryRequest {
    private String promptId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPromptId() {
        return this.promptId;
    }

    public void setPromptId(String promptId) {
        this.promptId = promptId;
    }

    public PostArchitectPromptHistoryRequest withPromptId(String promptId) {
        this.setPromptId(promptId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostArchitectPromptHistoryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.promptId == null) {
            throw new IllegalStateException("Missing the required parameter 'promptId' when building request for PostArchitectPromptHistoryRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/architect/prompts/{promptId}/history").withPathParameter("promptId", this.promptId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String promptId) {
        return new Builder().withRequiredParams(promptId);
    }

    public static class Builder {
        private final PostArchitectPromptHistoryRequest request = new PostArchitectPromptHistoryRequest();

        private Builder() {
        }

        public Builder withPromptId(String promptId) {
            this.request.setPromptId(promptId);
            return this;
        }

        public Builder withRequiredParams(String promptId) {
            this.request.setPromptId(promptId);
            return this;
        }

        public PostArchitectPromptHistoryRequest build() {
            if (this.request.promptId == null) {
                throw new IllegalStateException("Missing the required parameter 'promptId' when building request for PostArchitectPromptHistoryRequest.");
            }
            return this.request;
        }
    }
}

