/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetAppfoundryPlatformNameCategoriesRequest;
import com.mypurecloud.sdk.v2.api.request.GetAppfoundryPlatformNameCategoryRequest;
import com.mypurecloud.sdk.v2.api.request.GetAppfoundryPlatformNameCategorySubCategoryNameRequest;
import com.mypurecloud.sdk.v2.model.AppFoundryListingCategory;
import com.mypurecloud.sdk.v2.model.PagedListingEntity;
import java.io.IOException;
import java.util.List;

public class AppFoundryApi {
    private final ApiClient pcapiClient;

    public AppFoundryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AppFoundryApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public List<AppFoundryListingCategory> getAppfoundryPlatformNameCategories(String platformName) throws IOException, ApiException {
        return this.getAppfoundryPlatformNameCategories(this.createGetAppfoundryPlatformNameCategoriesRequest(platformName));
    }

    public ApiResponse<List<AppFoundryListingCategory>> getAppfoundryPlatformNameCategoriesWithHttpInfo(String platformName) throws IOException {
        return this.getAppfoundryPlatformNameCategories(this.createGetAppfoundryPlatformNameCategoriesRequest(platformName).withHttpInfo());
    }

    private GetAppfoundryPlatformNameCategoriesRequest createGetAppfoundryPlatformNameCategoriesRequest(String platformName) {
        return GetAppfoundryPlatformNameCategoriesRequest.builder().withPlatformName(platformName).build();
    }

    public List<AppFoundryListingCategory> getAppfoundryPlatformNameCategories(GetAppfoundryPlatformNameCategoriesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<AppFoundryListingCategory>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<AppFoundryListingCategory>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<AppFoundryListingCategory>> getAppfoundryPlatformNameCategories(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<AppFoundryListingCategory>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PagedListingEntity getAppfoundryPlatformNameCategory(String platformName, String categoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getAppfoundryPlatformNameCategory(this.createGetAppfoundryPlatformNameCategoryRequest(platformName, categoryName, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<PagedListingEntity> getAppfoundryPlatformNameCategoryWithHttpInfo(String platformName, String categoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) throws IOException {
        return this.getAppfoundryPlatformNameCategory(this.createGetAppfoundryPlatformNameCategoryRequest(platformName, categoryName, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetAppfoundryPlatformNameCategoryRequest createGetAppfoundryPlatformNameCategoryRequest(String platformName, String categoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) {
        return GetAppfoundryPlatformNameCategoryRequest.builder().withPlatformName(platformName).withCategoryName(categoryName).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public PagedListingEntity getAppfoundryPlatformNameCategory(GetAppfoundryPlatformNameCategoryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PagedListingEntity> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PagedListingEntity>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PagedListingEntity> getAppfoundryPlatformNameCategory(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PagedListingEntity>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PagedListingEntity getAppfoundryPlatformNameCategorySubCategoryName(String platformName, String categoryName, String subCategoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getAppfoundryPlatformNameCategorySubCategoryName(this.createGetAppfoundryPlatformNameCategorySubCategoryNameRequest(platformName, categoryName, subCategoryName, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<PagedListingEntity> getAppfoundryPlatformNameCategorySubCategoryNameWithHttpInfo(String platformName, String categoryName, String subCategoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) throws IOException {
        return this.getAppfoundryPlatformNameCategorySubCategoryName(this.createGetAppfoundryPlatformNameCategorySubCategoryNameRequest(platformName, categoryName, subCategoryName, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetAppfoundryPlatformNameCategorySubCategoryNameRequest createGetAppfoundryPlatformNameCategorySubCategoryNameRequest(String platformName, String categoryName, String subCategoryName, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage) {
        return GetAppfoundryPlatformNameCategorySubCategoryNameRequest.builder().withPlatformName(platformName).withCategoryName(categoryName).withSubCategoryName(subCategoryName).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public PagedListingEntity getAppfoundryPlatformNameCategorySubCategoryName(GetAppfoundryPlatformNameCategorySubCategoryNameRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PagedListingEntity> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PagedListingEntity>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PagedListingEntity> getAppfoundryPlatformNameCategorySubCategoryName(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PagedListingEntity>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

